// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.implementation.models;

import com.azure.ai.agents.persistent.models.VectorStoreChunkingStrategyRequest;
import com.azure.ai.agents.persistent.models.VectorStoreConfiguration;
import com.azure.ai.agents.persistent.models.VectorStoreExpirationPolicy;
import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * The CreateVectorStoreRequest model.
 */
@Fluent
public final class CreateVectorStoreRequest implements JsonSerializable<CreateVectorStoreRequest> {

    /*
     * A list of file IDs that the vector store should use. Useful for tools like `file_search` that can access files.
     */
    @Generated
    private List<String> fileIds;

    /*
     * The name of the vector store.
     */
    @Generated
    private String name;

    /*
     * The vector store configuration, used when vector store is created from Azure asset URIs.
     */
    @Generated
    private VectorStoreConfiguration storeConfiguration;

    /*
     * Details on when this vector store expires
     */
    @Generated
    private VectorStoreExpirationPolicy expiresAfter;

    /*
     * The chunking strategy used to chunk the file(s). If not set, will use the auto strategy. Only applicable if
     * file_ids is non-empty.
     */
    @Generated
    private VectorStoreChunkingStrategyRequest chunkingStrategy;

    /*
     * A set of up to 16 key/value pairs that can be attached to an object, used for storing additional information
     * about that object in a structured format. Keys may be up to 64 characters in length and values may be up to 512
     * characters in length.
     */
    @Generated
    private Map<String, String> metadata;

    /**
     * Creates an instance of CreateVectorStoreRequest class.
     */
    @Generated
    public CreateVectorStoreRequest() {
    }

    /**
     * Get the fileIds property: A list of file IDs that the vector store should use. Useful for tools like
     * `file_search` that can access files.
     *
     * @return the fileIds value.
     */
    @Generated
    public List<String> getFileIds() {
        return this.fileIds;
    }

    /**
     * Set the fileIds property: A list of file IDs that the vector store should use. Useful for tools like
     * `file_search` that can access files.
     *
     * @param fileIds the fileIds value to set.
     * @return the CreateVectorStoreRequest object itself.
     */
    @Generated
    public CreateVectorStoreRequest setFileIds(List<String> fileIds) {
        this.fileIds = fileIds;
        return this;
    }

    /**
     * Get the name property: The name of the vector store.
     *
     * @return the name value.
     */
    @Generated
    public String getName() {
        return this.name;
    }

    /**
     * Set the name property: The name of the vector store.
     *
     * @param name the name value to set.
     * @return the CreateVectorStoreRequest object itself.
     */
    @Generated
    public CreateVectorStoreRequest setName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the storeConfiguration property: The vector store configuration, used when vector store is created from Azure
     * asset URIs.
     *
     * @return the storeConfiguration value.
     */
    @Generated
    public VectorStoreConfiguration getStoreConfiguration() {
        return this.storeConfiguration;
    }

    /**
     * Set the storeConfiguration property: The vector store configuration, used when vector store is created from Azure
     * asset URIs.
     *
     * @param storeConfiguration the storeConfiguration value to set.
     * @return the CreateVectorStoreRequest object itself.
     */
    @Generated
    public CreateVectorStoreRequest setStoreConfiguration(VectorStoreConfiguration storeConfiguration) {
        this.storeConfiguration = storeConfiguration;
        return this;
    }

    /**
     * Get the expiresAfter property: Details on when this vector store expires.
     *
     * @return the expiresAfter value.
     */
    @Generated
    public VectorStoreExpirationPolicy getExpiresAfter() {
        return this.expiresAfter;
    }

    /**
     * Set the expiresAfter property: Details on when this vector store expires.
     *
     * @param expiresAfter the expiresAfter value to set.
     * @return the CreateVectorStoreRequest object itself.
     */
    @Generated
    public CreateVectorStoreRequest setExpiresAfter(VectorStoreExpirationPolicy expiresAfter) {
        this.expiresAfter = expiresAfter;
        return this;
    }

    /**
     * Get the chunkingStrategy property: The chunking strategy used to chunk the file(s). If not set, will use the auto
     * strategy. Only applicable if file_ids is non-empty.
     *
     * @return the chunkingStrategy value.
     */
    @Generated
    public VectorStoreChunkingStrategyRequest getChunkingStrategy() {
        return this.chunkingStrategy;
    }

    /**
     * Set the chunkingStrategy property: The chunking strategy used to chunk the file(s). If not set, will use the auto
     * strategy. Only applicable if file_ids is non-empty.
     *
     * @param chunkingStrategy the chunkingStrategy value to set.
     * @return the CreateVectorStoreRequest object itself.
     */
    @Generated
    public CreateVectorStoreRequest setChunkingStrategy(VectorStoreChunkingStrategyRequest chunkingStrategy) {
        this.chunkingStrategy = chunkingStrategy;
        return this;
    }

    /**
     * Get the metadata property: A set of up to 16 key/value pairs that can be attached to an object, used for storing
     * additional information about that object in a structured format. Keys may be up to 64 characters in length and
     * values may be up to 512 characters in length.
     *
     * @return the metadata value.
     */
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    /**
     * Set the metadata property: A set of up to 16 key/value pairs that can be attached to an object, used for storing
     * additional information about that object in a structured format. Keys may be up to 64 characters in length and
     * values may be up to 512 characters in length.
     *
     * @param metadata the metadata value to set.
     * @return the CreateVectorStoreRequest object itself.
     */
    @Generated
    public CreateVectorStoreRequest setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("file_ids", this.fileIds, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("configuration", this.storeConfiguration);
        jsonWriter.writeJsonField("expires_after", this.expiresAfter);
        jsonWriter.writeJsonField("chunking_strategy", this.chunkingStrategy);
        jsonWriter.writeMapField("metadata", this.metadata, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CreateVectorStoreRequest from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of CreateVectorStoreRequest if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the CreateVectorStoreRequest.
     */
    @Generated
    public static CreateVectorStoreRequest fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CreateVectorStoreRequest deserializedCreateVectorStoreRequest = new CreateVectorStoreRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("file_ids".equals(fieldName)) {
                    List<String> fileIds = reader.readArray(reader1 -> reader1.getString());
                    deserializedCreateVectorStoreRequest.fileIds = fileIds;
                } else if ("name".equals(fieldName)) {
                    deserializedCreateVectorStoreRequest.name = reader.getString();
                } else if ("configuration".equals(fieldName)) {
                    deserializedCreateVectorStoreRequest.storeConfiguration = VectorStoreConfiguration.fromJson(reader);
                } else if ("expires_after".equals(fieldName)) {
                    deserializedCreateVectorStoreRequest.expiresAfter = VectorStoreExpirationPolicy.fromJson(reader);
                } else if ("chunking_strategy".equals(fieldName)) {
                    deserializedCreateVectorStoreRequest.chunkingStrategy
                        = VectorStoreChunkingStrategyRequest.fromJson(reader);
                } else if ("metadata".equals(fieldName)) {
                    Map<String, String> metadata = reader.readMap(reader1 -> reader1.getString());
                    deserializedCreateVectorStoreRequest.metadata = metadata;
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedCreateVectorStoreRequest;
        });
    }
}
