// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.implementation.models;

import com.azure.ai.agents.persistent.models.VectorStoreExpirationPolicy;
import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

/**
 * The ModifyVectorStoreRequest model.
 */
@Fluent
public final class ModifyVectorStoreRequest implements JsonSerializable<ModifyVectorStoreRequest> {

    /*
     * The name of the vector store.
     */
    @Generated
    private String name;

    /*
     * Details on when this vector store expires
     */
    @Generated
    private VectorStoreExpirationPolicy expiresAfter;

    /*
     * A set of up to 16 key/value pairs that can be attached to an object, used for storing additional information
     * about that object in a structured format. Keys may be up to 64 characters in length and values may be up to 512
     * characters in length.
     */
    @Generated
    private Map<String, String> metadata;

    /**
     * Creates an instance of ModifyVectorStoreRequest class.
     */
    @Generated
    public ModifyVectorStoreRequest() {
    }

    /**
     * Get the name property: The name of the vector store.
     *
     * @return the name value.
     */
    @Generated
    public String getName() {
        return this.name;
    }

    /**
     * Set the name property: The name of the vector store.
     *
     * @param name the name value to set.
     * @return the ModifyVectorStoreRequest object itself.
     */
    @Generated
    public ModifyVectorStoreRequest setName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the expiresAfter property: Details on when this vector store expires.
     *
     * @return the expiresAfter value.
     */
    @Generated
    public VectorStoreExpirationPolicy getExpiresAfter() {
        return this.expiresAfter;
    }

    /**
     * Set the expiresAfter property: Details on when this vector store expires.
     *
     * @param expiresAfter the expiresAfter value to set.
     * @return the ModifyVectorStoreRequest object itself.
     */
    @Generated
    public ModifyVectorStoreRequest setExpiresAfter(VectorStoreExpirationPolicy expiresAfter) {
        this.expiresAfter = expiresAfter;
        return this;
    }

    /**
     * Get the metadata property: A set of up to 16 key/value pairs that can be attached to an object, used for storing
     * additional information about that object in a structured format. Keys may be up to 64 characters in length and
     * values may be up to 512 characters in length.
     *
     * @return the metadata value.
     */
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    /**
     * Set the metadata property: A set of up to 16 key/value pairs that can be attached to an object, used for storing
     * additional information about that object in a structured format. Keys may be up to 64 characters in length and
     * values may be up to 512 characters in length.
     *
     * @param metadata the metadata value to set.
     * @return the ModifyVectorStoreRequest object itself.
     */
    @Generated
    public ModifyVectorStoreRequest setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("expires_after", this.expiresAfter);
        jsonWriter.writeMapField("metadata", this.metadata, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ModifyVectorStoreRequest from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of ModifyVectorStoreRequest if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ModifyVectorStoreRequest.
     */
    @Generated
    public static ModifyVectorStoreRequest fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ModifyVectorStoreRequest deserializedModifyVectorStoreRequest = new ModifyVectorStoreRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedModifyVectorStoreRequest.name = reader.getString();
                } else if ("expires_after".equals(fieldName)) {
                    deserializedModifyVectorStoreRequest.expiresAfter = VectorStoreExpirationPolicy.fromJson(reader);
                } else if ("metadata".equals(fieldName)) {
                    Map<String, String> metadata = reader.readMap(reader1 -> reader1.getString());
                    deserializedModifyVectorStoreRequest.metadata = metadata;
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedModifyVectorStoreRequest;
        });
    }
}
