// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.implementation.models;

import com.azure.ai.agents.persistent.models.ToolDefinition;
import com.azure.ai.agents.persistent.models.ToolResources;
import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.core.util.BinaryData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * The UpdateAgentRequest model.
 */
@Fluent
public final class UpdateAgentRequest implements JsonSerializable<UpdateAgentRequest> {

    /*
     * The ID of the model to use.
     */
    @Generated
    private String model;

    /*
     * The modified name for the agent to use.
     */
    @Generated
    private String name;

    /*
     * The modified description for the agent to use.
     */
    @Generated
    private String description;

    /*
     * The modified system instructions for the new agent to use.
     */
    @Generated
    private String instructions;

    /*
     * The modified collection of tools to enable for the agent.
     */
    @Generated
    private List<ToolDefinition> tools;

    /*
     * A set of resources that are used by the agent's tools. The resources are specific to the type of tool. For
     * example,
     * the `code_interpreter` tool requires a list of file IDs, while the `file_search` tool requires a list of vector
     * store IDs.
     */
    @Generated
    private ToolResources toolResources;

    /*
     * What sampling temperature to use, between 0 and 2. Higher values like 0.8 will make the output more random,
     * while lower values like 0.2 will make it more focused and deterministic.
     */
    @Generated
    private Double temperature;

    /*
     * An alternative to sampling with temperature, called nucleus sampling, where the model considers the results of
     * the tokens with top_p probability mass.
     * So 0.1 means only the tokens comprising the top 10% probability mass are considered.
     * 
     * We generally recommend altering this or temperature but not both.
     */
    @Generated
    private Double topP;

    /*
     * The response format of the tool calls used by this agent.
     */
    @Generated
    private BinaryData responseFormat;

    /*
     * A set of up to 16 key/value pairs that can be attached to an object, used for storing additional information
     * about that object in a structured format. Keys may be up to 64 characters in length and values may be up to 512
     * characters in length.
     */
    @Generated
    private Map<String, String> metadata;

    /**
     * Creates an instance of UpdateAgentRequest class.
     */
    @Generated
    public UpdateAgentRequest() {
    }

    /**
     * Get the model property: The ID of the model to use.
     *
     * @return the model value.
     */
    @Generated
    public String getModel() {
        return this.model;
    }

    /**
     * Set the model property: The ID of the model to use.
     *
     * @param model the model value to set.
     * @return the UpdateAgentRequest object itself.
     */
    @Generated
    public UpdateAgentRequest setModel(String model) {
        this.model = model;
        return this;
    }

    /**
     * Get the name property: The modified name for the agent to use.
     *
     * @return the name value.
     */
    @Generated
    public String getName() {
        return this.name;
    }

    /**
     * Set the name property: The modified name for the agent to use.
     *
     * @param name the name value to set.
     * @return the UpdateAgentRequest object itself.
     */
    @Generated
    public UpdateAgentRequest setName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the description property: The modified description for the agent to use.
     *
     * @return the description value.
     */
    @Generated
    public String getDescription() {
        return this.description;
    }

    /**
     * Set the description property: The modified description for the agent to use.
     *
     * @param description the description value to set.
     * @return the UpdateAgentRequest object itself.
     */
    @Generated
    public UpdateAgentRequest setDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the instructions property: The modified system instructions for the new agent to use.
     *
     * @return the instructions value.
     */
    @Generated
    public String getInstructions() {
        return this.instructions;
    }

    /**
     * Set the instructions property: The modified system instructions for the new agent to use.
     *
     * @param instructions the instructions value to set.
     * @return the UpdateAgentRequest object itself.
     */
    @Generated
    public UpdateAgentRequest setInstructions(String instructions) {
        this.instructions = instructions;
        return this;
    }

    /**
     * Get the tools property: The modified collection of tools to enable for the agent.
     *
     * @return the tools value.
     */
    @Generated
    public List<ToolDefinition> getTools() {
        return this.tools;
    }

    /**
     * Set the tools property: The modified collection of tools to enable for the agent.
     *
     * @param tools the tools value to set.
     * @return the UpdateAgentRequest object itself.
     */
    @Generated
    public UpdateAgentRequest setTools(List<ToolDefinition> tools) {
        this.tools = tools;
        return this;
    }

    /**
     * Get the toolResources property: A set of resources that are used by the agent's tools. The resources are specific
     * to the type of tool. For example,
     * the `code_interpreter` tool requires a list of file IDs, while the `file_search` tool requires a list of vector
     * store IDs.
     *
     * @return the toolResources value.
     */
    @Generated
    public ToolResources getToolResources() {
        return this.toolResources;
    }

    /**
     * Set the toolResources property: A set of resources that are used by the agent's tools. The resources are specific
     * to the type of tool. For example,
     * the `code_interpreter` tool requires a list of file IDs, while the `file_search` tool requires a list of vector
     * store IDs.
     *
     * @param toolResources the toolResources value to set.
     * @return the UpdateAgentRequest object itself.
     */
    @Generated
    public UpdateAgentRequest setToolResources(ToolResources toolResources) {
        this.toolResources = toolResources;
        return this;
    }

    /**
     * Get the temperature property: What sampling temperature to use, between 0 and 2. Higher values like 0.8 will make
     * the output more random,
     * while lower values like 0.2 will make it more focused and deterministic.
     *
     * @return the temperature value.
     */
    @Generated
    public Double getTemperature() {
        return this.temperature;
    }

    /**
     * Set the temperature property: What sampling temperature to use, between 0 and 2. Higher values like 0.8 will make
     * the output more random,
     * while lower values like 0.2 will make it more focused and deterministic.
     *
     * @param temperature the temperature value to set.
     * @return the UpdateAgentRequest object itself.
     */
    @Generated
    public UpdateAgentRequest setTemperature(Double temperature) {
        this.temperature = temperature;
        return this;
    }

    /**
     * Get the topP property: An alternative to sampling with temperature, called nucleus sampling, where the model
     * considers the results of the tokens with top_p probability mass.
     * So 0.1 means only the tokens comprising the top 10% probability mass are considered.
     *
     * We generally recommend altering this or temperature but not both.
     *
     * @return the topP value.
     */
    @Generated
    public Double getTopP() {
        return this.topP;
    }

    /**
     * Set the topP property: An alternative to sampling with temperature, called nucleus sampling, where the model
     * considers the results of the tokens with top_p probability mass.
     * So 0.1 means only the tokens comprising the top 10% probability mass are considered.
     *
     * We generally recommend altering this or temperature but not both.
     *
     * @param topP the topP value to set.
     * @return the UpdateAgentRequest object itself.
     */
    @Generated
    public UpdateAgentRequest setTopP(Double topP) {
        this.topP = topP;
        return this;
    }

    /**
     * Get the responseFormat property: The response format of the tool calls used by this agent.
     *
     * @return the responseFormat value.
     */
    @Generated
    public BinaryData getResponseFormat() {
        return this.responseFormat;
    }

    /**
     * Set the responseFormat property: The response format of the tool calls used by this agent.
     *
     * @param responseFormat the responseFormat value to set.
     * @return the UpdateAgentRequest object itself.
     */
    @Generated
    public UpdateAgentRequest setResponseFormat(BinaryData responseFormat) {
        this.responseFormat = responseFormat;
        return this;
    }

    /**
     * Get the metadata property: A set of up to 16 key/value pairs that can be attached to an object, used for storing
     * additional information about that object in a structured format. Keys may be up to 64 characters in length and
     * values may be up to 512 characters in length.
     *
     * @return the metadata value.
     */
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    /**
     * Set the metadata property: A set of up to 16 key/value pairs that can be attached to an object, used for storing
     * additional information about that object in a structured format. Keys may be up to 64 characters in length and
     * values may be up to 512 characters in length.
     *
     * @param metadata the metadata value to set.
     * @return the UpdateAgentRequest object itself.
     */
    @Generated
    public UpdateAgentRequest setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("model", this.model);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("instructions", this.instructions);
        jsonWriter.writeArrayField("tools", this.tools, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("tool_resources", this.toolResources);
        jsonWriter.writeNumberField("temperature", this.temperature);
        jsonWriter.writeNumberField("top_p", this.topP);
        if (this.responseFormat != null) {
            jsonWriter.writeFieldName("response_format");
            this.responseFormat.writeTo(jsonWriter);
        }
        jsonWriter.writeMapField("metadata", this.metadata, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of UpdateAgentRequest from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of UpdateAgentRequest if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the UpdateAgentRequest.
     */
    @Generated
    public static UpdateAgentRequest fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            UpdateAgentRequest deserializedUpdateAgentRequest = new UpdateAgentRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("model".equals(fieldName)) {
                    deserializedUpdateAgentRequest.model = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedUpdateAgentRequest.name = reader.getString();
                } else if ("description".equals(fieldName)) {
                    deserializedUpdateAgentRequest.description = reader.getString();
                } else if ("instructions".equals(fieldName)) {
                    deserializedUpdateAgentRequest.instructions = reader.getString();
                } else if ("tools".equals(fieldName)) {
                    List<ToolDefinition> tools = reader.readArray(reader1 -> ToolDefinition.fromJson(reader1));
                    deserializedUpdateAgentRequest.tools = tools;
                } else if ("tool_resources".equals(fieldName)) {
                    deserializedUpdateAgentRequest.toolResources = ToolResources.fromJson(reader);
                } else if ("temperature".equals(fieldName)) {
                    deserializedUpdateAgentRequest.temperature = reader.getNullable(JsonReader::getDouble);
                } else if ("top_p".equals(fieldName)) {
                    deserializedUpdateAgentRequest.topP = reader.getNullable(JsonReader::getDouble);
                } else if ("response_format".equals(fieldName)) {
                    deserializedUpdateAgentRequest.responseFormat
                        = reader.getNullable(nonNullReader -> BinaryData.fromObject(nonNullReader.readUntyped()));
                } else if ("metadata".equals(fieldName)) {
                    Map<String, String> metadata = reader.readMap(reader1 -> reader1.getString());
                    deserializedUpdateAgentRequest.metadata = metadata;
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedUpdateAgentRequest;
        });
    }
}
