// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * A AI Search Index resource.
 */
@Fluent
public final class AISearchIndexResource implements JsonSerializable<AISearchIndexResource> {

    /*
     * An index connection id in an IndexResource attached to this agent.
     */
    @Generated
    private String indexConnectionId;

    /*
     * The name of an index in an IndexResource attached to this agent.
     */
    @Generated
    private String indexName;

    /*
     * Type of query in an AIIndexResource attached to this agent.
     */
    @Generated
    private AzureAISearchQueryType queryType;

    /*
     * Number of documents to retrieve from search and present to the model.
     */
    @Generated
    private Integer topK;

    /*
     * filter string for search resource.
     */
    @Generated
    private String filter;

    /*
     * Index asset id for search resource.
     */
    @Generated
    private String indexAssetId;

    /**
     * Creates an instance of AISearchIndexResource class.
     */
    @Generated
    public AISearchIndexResource() {
    }

    /**
     * Get the indexConnectionId property: An index connection id in an IndexResource attached to this agent.
     *
     * @return the indexConnectionId value.
     */
    @Generated
    public String getIndexConnectionId() {
        return this.indexConnectionId;
    }

    /**
     * Set the indexConnectionId property: An index connection id in an IndexResource attached to this agent.
     *
     * @param indexConnectionId the indexConnectionId value to set.
     * @return the AISearchIndexResource object itself.
     */
    @Generated
    public AISearchIndexResource setIndexConnectionId(String indexConnectionId) {
        this.indexConnectionId = indexConnectionId;
        return this;
    }

    /**
     * Get the indexName property: The name of an index in an IndexResource attached to this agent.
     *
     * @return the indexName value.
     */
    @Generated
    public String getIndexName() {
        return this.indexName;
    }

    /**
     * Set the indexName property: The name of an index in an IndexResource attached to this agent.
     *
     * @param indexName the indexName value to set.
     * @return the AISearchIndexResource object itself.
     */
    @Generated
    public AISearchIndexResource setIndexName(String indexName) {
        this.indexName = indexName;
        return this;
    }

    /**
     * Get the queryType property: Type of query in an AIIndexResource attached to this agent.
     *
     * @return the queryType value.
     */
    @Generated
    public AzureAISearchQueryType getQueryType() {
        return this.queryType;
    }

    /**
     * Set the queryType property: Type of query in an AIIndexResource attached to this agent.
     *
     * @param queryType the queryType value to set.
     * @return the AISearchIndexResource object itself.
     */
    @Generated
    public AISearchIndexResource setQueryType(AzureAISearchQueryType queryType) {
        this.queryType = queryType;
        return this;
    }

    /**
     * Get the topK property: Number of documents to retrieve from search and present to the model.
     *
     * @return the topK value.
     */
    @Generated
    public Integer getTopK() {
        return this.topK;
    }

    /**
     * Set the topK property: Number of documents to retrieve from search and present to the model.
     *
     * @param topK the topK value to set.
     * @return the AISearchIndexResource object itself.
     */
    @Generated
    public AISearchIndexResource setTopK(Integer topK) {
        this.topK = topK;
        return this;
    }

    /**
     * Get the filter property: filter string for search resource.
     *
     * @return the filter value.
     */
    @Generated
    public String getFilter() {
        return this.filter;
    }

    /**
     * Set the filter property: filter string for search resource.
     *
     * @param filter the filter value to set.
     * @return the AISearchIndexResource object itself.
     */
    @Generated
    public AISearchIndexResource setFilter(String filter) {
        this.filter = filter;
        return this;
    }

    /**
     * Get the indexAssetId property: Index asset id for search resource.
     *
     * @return the indexAssetId value.
     */
    @Generated
    public String getIndexAssetId() {
        return this.indexAssetId;
    }

    /**
     * Set the indexAssetId property: Index asset id for search resource.
     *
     * @param indexAssetId the indexAssetId value to set.
     * @return the AISearchIndexResource object itself.
     */
    @Generated
    public AISearchIndexResource setIndexAssetId(String indexAssetId) {
        this.indexAssetId = indexAssetId;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("index_connection_id", this.indexConnectionId);
        jsonWriter.writeStringField("index_name", this.indexName);
        jsonWriter.writeStringField("query_type", this.queryType == null ? null : this.queryType.toString());
        jsonWriter.writeNumberField("top_k", this.topK);
        jsonWriter.writeStringField("filter", this.filter);
        jsonWriter.writeStringField("index_asset_id", this.indexAssetId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AISearchIndexResource from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of AISearchIndexResource if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AISearchIndexResource.
     */
    @Generated
    public static AISearchIndexResource fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AISearchIndexResource deserializedAISearchIndexResource = new AISearchIndexResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("index_connection_id".equals(fieldName)) {
                    deserializedAISearchIndexResource.indexConnectionId = reader.getString();
                } else if ("index_name".equals(fieldName)) {
                    deserializedAISearchIndexResource.indexName = reader.getString();
                } else if ("query_type".equals(fieldName)) {
                    deserializedAISearchIndexResource.queryType = AzureAISearchQueryType.fromString(reader.getString());
                } else if ("top_k".equals(fieldName)) {
                    deserializedAISearchIndexResource.topK = reader.getNullable(JsonReader::getInt);
                } else if ("filter".equals(fieldName)) {
                    deserializedAISearchIndexResource.filter = reader.getString();
                } else if ("index_asset_id".equals(fieldName)) {
                    deserializedAISearchIndexResource.indexAssetId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedAISearchIndexResource;
        });
    }
}
