// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Available query types for Azure AI Search tool.
 */
public final class AzureAISearchQueryType extends ExpandableStringEnum<AzureAISearchQueryType> {

    /**
     * Query type `simple`.
     */
    @Generated
    public static final AzureAISearchQueryType SIMPLE = fromString("simple");

    /**
     * Query type `semantic`.
     */
    @Generated
    public static final AzureAISearchQueryType SEMANTIC = fromString("semantic");

    /**
     * Query type `vector`.
     */
    @Generated
    public static final AzureAISearchQueryType VECTOR = fromString("vector");

    /**
     * Query type `vector_simple_hybrid`.
     */
    @Generated
    public static final AzureAISearchQueryType VECTOR_SIMPLE_HYBRID = fromString("vector_simple_hybrid");

    /**
     * Query type `vector_semantic_hybrid`.
     */
    @Generated
    public static final AzureAISearchQueryType VECTOR_SEMANTIC_HYBRID = fromString("vector_semantic_hybrid");

    /**
     * Creates a new instance of AzureAISearchQueryType value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Generated
    @Deprecated
    public AzureAISearchQueryType() {
    }

    /**
     * Creates or finds a AzureAISearchQueryType from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding AzureAISearchQueryType.
     */
    @Generated
    public static AzureAISearchQueryType fromString(String name) {
        return fromString(name, AzureAISearchQueryType.class);
    }

    /**
     * Gets known AzureAISearchQueryType values.
     *
     * @return known AzureAISearchQueryType values.
     */
    @Generated
    public static Collection<AzureAISearchQueryType> values() {
        return values(AzureAISearchQueryType.class);
    }
}
