// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * A set of index resources used by the `azure_ai_search` tool.
 */
@Fluent
public final class AzureAISearchToolResource implements JsonSerializable<AzureAISearchToolResource> {

    /*
     * The indices attached to this agent. There can be a maximum of 1 index
     * resource attached to the agent.
     */
    @Generated
    private List<AISearchIndexResource> indexList;

    /**
     * Creates an instance of AzureAISearchToolResource class.
     */
    @Generated
    public AzureAISearchToolResource() {
    }

    /**
     * Get the indexList property: The indices attached to this agent. There can be a maximum of 1 index
     * resource attached to the agent.
     *
     * @return the indexList value.
     */
    @Generated
    public List<AISearchIndexResource> getIndexList() {
        return this.indexList;
    }

    /**
     * Set the indexList property: The indices attached to this agent. There can be a maximum of 1 index
     * resource attached to the agent.
     *
     * @param indexList the indexList value to set.
     * @return the AzureAISearchToolResource object itself.
     */
    @Generated
    public AzureAISearchToolResource setIndexList(List<AISearchIndexResource> indexList) {
        this.indexList = indexList;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("indexes", this.indexList, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AzureAISearchToolResource from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of AzureAISearchToolResource if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AzureAISearchToolResource.
     */
    @Generated
    public static AzureAISearchToolResource fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AzureAISearchToolResource deserializedAzureAISearchToolResource = new AzureAISearchToolResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("indexes".equals(fieldName)) {
                    List<AISearchIndexResource> indexList
                        = reader.readArray(reader1 -> AISearchIndexResource.fromJson(reader1));
                    deserializedAzureAISearchToolResource.indexList = indexList;
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedAzureAISearchToolResource;
        });
    }
}
