// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The structure for keeping storage queue name and URI.
 */
@Immutable
public final class AzureFunctionBinding implements JsonSerializable<AzureFunctionBinding> {

    /*
     * The type of binding, which is always 'storage_queue'.
     */
    @Generated
    private final String type = "storage_queue";

    /*
     * Storage queue.
     */
    @Generated
    private final AzureFunctionStorageQueue storageQueue;

    /**
     * Creates an instance of AzureFunctionBinding class.
     *
     * @param storageQueue the storageQueue value to set.
     */
    @Generated
    public AzureFunctionBinding(AzureFunctionStorageQueue storageQueue) {
        this.storageQueue = storageQueue;
    }

    /**
     * Get the type property: The type of binding, which is always 'storage_queue'.
     *
     * @return the type value.
     */
    @Generated
    public String getType() {
        return this.type;
    }

    /**
     * Get the storageQueue property: Storage queue.
     *
     * @return the storageQueue value.
     */
    @Generated
    public AzureFunctionStorageQueue getStorageQueue() {
        return this.storageQueue;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeJsonField("storage_queue", this.storageQueue);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AzureFunctionBinding from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of AzureFunctionBinding if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AzureFunctionBinding.
     */
    @Generated
    public static AzureFunctionBinding fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AzureFunctionStorageQueue storageQueue = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("storage_queue".equals(fieldName)) {
                    storageQueue = AzureFunctionStorageQueue.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }
            return new AzureFunctionBinding(storageQueue);
        });
    }
}
