// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The definition of Azure function.
 */
@Immutable
public final class AzureFunctionDefinition implements JsonSerializable<AzureFunctionDefinition> {

    /*
     * The definition of azure function and its parameters.
     */
    @Generated
    private final FunctionDefinition function;

    /*
     * Input storage queue. The queue storage trigger runs a function as messages are added to it.
     */
    @Generated
    private final AzureFunctionBinding inputBinding;

    /*
     * Output storage queue. The function writes output to this queue when the input items are processed.
     */
    @Generated
    private final AzureFunctionBinding outputBinding;

    /**
     * Creates an instance of AzureFunctionDefinition class.
     *
     * @param function the function value to set.
     * @param inputBinding the inputBinding value to set.
     * @param outputBinding the outputBinding value to set.
     */
    @Generated
    public AzureFunctionDefinition(FunctionDefinition function, AzureFunctionBinding inputBinding,
        AzureFunctionBinding outputBinding) {
        this.function = function;
        this.inputBinding = inputBinding;
        this.outputBinding = outputBinding;
    }

    /**
     * Get the function property: The definition of azure function and its parameters.
     *
     * @return the function value.
     */
    @Generated
    public FunctionDefinition getFunction() {
        return this.function;
    }

    /**
     * Get the inputBinding property: Input storage queue. The queue storage trigger runs a function as messages are
     * added to it.
     *
     * @return the inputBinding value.
     */
    @Generated
    public AzureFunctionBinding getInputBinding() {
        return this.inputBinding;
    }

    /**
     * Get the outputBinding property: Output storage queue. The function writes output to this queue when the input
     * items are processed.
     *
     * @return the outputBinding value.
     */
    @Generated
    public AzureFunctionBinding getOutputBinding() {
        return this.outputBinding;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("function", this.function);
        jsonWriter.writeJsonField("input_binding", this.inputBinding);
        jsonWriter.writeJsonField("output_binding", this.outputBinding);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AzureFunctionDefinition from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of AzureFunctionDefinition if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AzureFunctionDefinition.
     */
    @Generated
    public static AzureFunctionDefinition fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            FunctionDefinition function = null;
            AzureFunctionBinding inputBinding = null;
            AzureFunctionBinding outputBinding = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("function".equals(fieldName)) {
                    function = FunctionDefinition.fromJson(reader);
                } else if ("input_binding".equals(fieldName)) {
                    inputBinding = AzureFunctionBinding.fromJson(reader);
                } else if ("output_binding".equals(fieldName)) {
                    outputBinding = AzureFunctionBinding.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }
            return new AzureFunctionDefinition(function, inputBinding, outputBinding);
        });
    }
}
