// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The structure for keeping storage queue name and URI.
 */
@Immutable
public final class AzureFunctionStorageQueue implements JsonSerializable<AzureFunctionStorageQueue> {

    /*
     * URI to the Azure Storage Queue service allowing you to manipulate a queue.
     */
    @Generated
    private final String storageServiceEndpoint;

    /*
     * The name of an Azure function storage queue.
     */
    @Generated
    private final String queueName;

    /**
     * Creates an instance of AzureFunctionStorageQueue class.
     *
     * @param storageServiceEndpoint the storageServiceEndpoint value to set.
     * @param queueName the queueName value to set.
     */
    @Generated
    public AzureFunctionStorageQueue(String storageServiceEndpoint, String queueName) {
        this.storageServiceEndpoint = storageServiceEndpoint;
        this.queueName = queueName;
    }

    /**
     * Get the storageServiceEndpoint property: URI to the Azure Storage Queue service allowing you to manipulate a
     * queue.
     *
     * @return the storageServiceEndpoint value.
     */
    @Generated
    public String getStorageServiceEndpoint() {
        return this.storageServiceEndpoint;
    }

    /**
     * Get the queueName property: The name of an Azure function storage queue.
     *
     * @return the queueName value.
     */
    @Generated
    public String getQueueName() {
        return this.queueName;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("queue_service_endpoint", this.storageServiceEndpoint);
        jsonWriter.writeStringField("queue_name", this.queueName);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AzureFunctionStorageQueue from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of AzureFunctionStorageQueue if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AzureFunctionStorageQueue.
     */
    @Generated
    public static AzureFunctionStorageQueue fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String storageServiceEndpoint = null;
            String queueName = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("queue_service_endpoint".equals(fieldName)) {
                    storageServiceEndpoint = reader.getString();
                } else if ("queue_name".equals(fieldName)) {
                    queueName = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            return new AzureFunctionStorageQueue(storageServiceEndpoint, queueName);
        });
    }
}
