// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * A bing custom search configuration.
 */
@Fluent
public final class BingCustomSearchConfiguration implements JsonSerializable<BingCustomSearchConfiguration> {

    /*
     * Connection id for grounding with bing search
     */
    @Generated
    private final String connectionId;

    /*
     * Name of the custom configuration instance given to config.
     */
    @Generated
    private final String instanceName;

    /*
     * The market where the results come from.
     */
    @Generated
    private String market;

    /*
     * The number of search results to return in the bing api response
     */
    @Generated
    private Long count;

    /*
     * Filter search results by a specific time range. Accepted values:
     * https://learn.microsoft.com/bing/search-apis/bing-web-search/reference/query-parameters
     */
    @Generated
    private String freshness;

    /**
     * Creates an instance of BingCustomSearchConfiguration class.
     *
     * @param connectionId the connectionId value to set.
     * @param instanceName the instanceName value to set.
     */
    @Generated
    public BingCustomSearchConfiguration(String connectionId, String instanceName) {
        this.connectionId = connectionId;
        this.instanceName = instanceName;
    }

    /**
     * Get the connectionId property: Connection id for grounding with bing search.
     *
     * @return the connectionId value.
     */
    @Generated
    public String getConnectionId() {
        return this.connectionId;
    }

    /**
     * Get the instanceName property: Name of the custom configuration instance given to config.
     *
     * @return the instanceName value.
     */
    @Generated
    public String getInstanceName() {
        return this.instanceName;
    }

    /**
     * Get the market property: The market where the results come from.
     *
     * @return the market value.
     */
    @Generated
    public String getMarket() {
        return this.market;
    }

    /**
     * Set the market property: The market where the results come from.
     *
     * @param market the market value to set.
     * @return the BingCustomSearchConfiguration object itself.
     */
    @Generated
    public BingCustomSearchConfiguration setMarket(String market) {
        this.market = market;
        return this;
    }

    /**
     * Get the count property: The number of search results to return in the bing api response.
     *
     * @return the count value.
     */
    @Generated
    public Long getCount() {
        return this.count;
    }

    /**
     * Set the count property: The number of search results to return in the bing api response.
     *
     * @param count the count value to set.
     * @return the BingCustomSearchConfiguration object itself.
     */
    @Generated
    public BingCustomSearchConfiguration setCount(Long count) {
        this.count = count;
        return this;
    }

    /**
     * Get the freshness property: Filter search results by a specific time range. Accepted values:
     * https://learn.microsoft.com/bing/search-apis/bing-web-search/reference/query-parameters.
     *
     * @return the freshness value.
     */
    @Generated
    public String getFreshness() {
        return this.freshness;
    }

    /**
     * Set the freshness property: Filter search results by a specific time range. Accepted values:
     * https://learn.microsoft.com/bing/search-apis/bing-web-search/reference/query-parameters.
     *
     * @param freshness the freshness value to set.
     * @return the BingCustomSearchConfiguration object itself.
     */
    @Generated
    public BingCustomSearchConfiguration setFreshness(String freshness) {
        this.freshness = freshness;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("connection_id", this.connectionId);
        jsonWriter.writeStringField("instance_name", this.instanceName);
        jsonWriter.writeStringField("market", this.market);
        jsonWriter.writeStringField("set_lang", this.language);
        jsonWriter.writeNumberField("count", this.count);
        jsonWriter.writeStringField("freshness", this.freshness);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of BingCustomSearchConfiguration from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of BingCustomSearchConfiguration if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the BingCustomSearchConfiguration.
     */
    @Generated
    public static BingCustomSearchConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String connectionId = null;
            String instanceName = null;
            String market = null;
            String language = null;
            Long count = null;
            String freshness = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("connection_id".equals(fieldName)) {
                    connectionId = reader.getString();
                } else if ("instance_name".equals(fieldName)) {
                    instanceName = reader.getString();
                } else if ("market".equals(fieldName)) {
                    market = reader.getString();
                } else if ("set_lang".equals(fieldName)) {
                    language = reader.getString();
                } else if ("count".equals(fieldName)) {
                    count = reader.getNullable(JsonReader::getLong);
                } else if ("freshness".equals(fieldName)) {
                    freshness = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            BingCustomSearchConfiguration deserializedBingCustomSearchConfiguration
                = new BingCustomSearchConfiguration(connectionId, instanceName);
            deserializedBingCustomSearchConfiguration.market = market;
            deserializedBingCustomSearchConfiguration.language = language;
            deserializedBingCustomSearchConfiguration.count = count;
            deserializedBingCustomSearchConfiguration.freshness = freshness;
            return deserializedBingCustomSearchConfiguration;
        });
    }

    /*
     * The language to use for user interface strings when calling Bing API.
     */
    @Generated
    private String language;

    /**
     * Get the language property: The language to use for user interface strings when calling Bing API.
     *
     * @return the language value.
     */
    @Generated
    public String getLanguage() {
        return this.language;
    }

    /**
     * Set the language property: The language to use for user interface strings when calling Bing API.
     *
     * @param language the language value to set.
     * @return the BingCustomSearchConfiguration object itself.
     */
    @Generated
    public BingCustomSearchConfiguration setLanguage(String language) {
        this.language = language;
        return this;
    }
}
