// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The input definition information for a Bing custom search tool as used to configure an agent.
 */
@Immutable
public final class BingCustomSearchToolDefinition extends ToolDefinition {

    /*
     * The object type.
     */
    @Generated
    private String type = "bing_custom_search";

    /*
     * The bing custom search tool parameters.
     */
    @Generated
    private final BingCustomSearchToolParameters bingCustomSearch;

    /**
     * Creates an instance of BingCustomSearchToolDefinition class.
     *
     * @param bingCustomSearch the bingCustomSearch value to set.
     */
    @Generated
    public BingCustomSearchToolDefinition(BingCustomSearchToolParameters bingCustomSearch) {
        this.bingCustomSearch = bingCustomSearch;
    }

    /**
     * Get the type property: The object type.
     *
     * @return the type value.
     */
    @Generated
    @Override
    public String getType() {
        return this.type;
    }

    /**
     * Get the bingCustomSearch property: The bing custom search tool parameters.
     *
     * @return the bingCustomSearch value.
     */
    @Generated
    public BingCustomSearchToolParameters getBingCustomSearch() {
        return this.bingCustomSearch;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("bing_custom_search", this.bingCustomSearch);
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of BingCustomSearchToolDefinition from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of BingCustomSearchToolDefinition if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the BingCustomSearchToolDefinition.
     */
    @Generated
    public static BingCustomSearchToolDefinition fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BingCustomSearchToolParameters bingCustomSearch = null;
            String type = "bing_custom_search";
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("bing_custom_search".equals(fieldName)) {
                    bingCustomSearch = BingCustomSearchToolParameters.fromJson(reader);
                } else if ("type".equals(fieldName)) {
                    type = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            BingCustomSearchToolDefinition deserializedBingCustomSearchToolDefinition
                = new BingCustomSearchToolDefinition(bingCustomSearch);
            deserializedBingCustomSearchToolDefinition.type = type;
            return deserializedBingCustomSearchToolDefinition;
        });
    }
}
