// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The bing grounding search tool parameters.
 */
@Immutable
public final class BingGroundingSearchToolParameters implements JsonSerializable<BingGroundingSearchToolParameters> {

    /*
     * The search configurations attached to this tool. There can be a maximum of 1
     * search configuration resource attached to the tool.
     */
    @Generated
    private final List<BingGroundingSearchConfiguration> searchConfigurations;

    /**
     * Creates an instance of BingGroundingSearchToolParameters class.
     *
     * @param searchConfigurations the searchConfigurations value to set.
     */
    @Generated
    public BingGroundingSearchToolParameters(List<BingGroundingSearchConfiguration> searchConfigurations) {
        this.searchConfigurations = searchConfigurations;
    }

    /**
     * Get the searchConfigurations property: The search configurations attached to this tool. There can be a maximum of
     * 1
     * search configuration resource attached to the tool.
     *
     * @return the searchConfigurations value.
     */
    @Generated
    public List<BingGroundingSearchConfiguration> getSearchConfigurations() {
        return this.searchConfigurations;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("search_configurations", this.searchConfigurations,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of BingGroundingSearchToolParameters from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of BingGroundingSearchToolParameters if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the BingGroundingSearchToolParameters.
     */
    @Generated
    public static BingGroundingSearchToolParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            List<BingGroundingSearchConfiguration> searchConfigurations = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("search_configurations".equals(fieldName)) {
                    searchConfigurations
                        = reader.readArray(reader1 -> BingGroundingSearchConfiguration.fromJson(reader1));
                } else {
                    reader.skipChildren();
                }
            }
            return new BingGroundingSearchToolParameters(searchConfigurations);
        });
    }
}
