// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The input definition information for a code interpreter tool as used to configure an agent.
 */
@Immutable
public final class CodeInterpreterToolDefinition extends ToolDefinition {

    /*
     * The object type.
     */
    @Generated
    private String type = "code_interpreter";

    /**
     * Creates an instance of CodeInterpreterToolDefinition class.
     */
    @Generated
    public CodeInterpreterToolDefinition() {
    }

    /**
     * Get the type property: The object type.
     *
     * @return the type value.
     */
    @Generated
    @Override
    public String getType() {
        return this.type;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CodeInterpreterToolDefinition from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of CodeInterpreterToolDefinition if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the CodeInterpreterToolDefinition.
     */
    @Generated
    public static CodeInterpreterToolDefinition fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CodeInterpreterToolDefinition deserializedCodeInterpreterToolDefinition
                = new CodeInterpreterToolDefinition();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedCodeInterpreterToolDefinition.type = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedCodeInterpreterToolDefinition;
        });
    }
}
