// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * A set of resources that are used by the `code_interpreter` tool.
 */
@Fluent
public final class CodeInterpreterToolResource implements JsonSerializable<CodeInterpreterToolResource> {

    /*
     * A list of file IDs made available to the `code_interpreter` tool. There can be a maximum of 20 files
     * associated with the tool.
     */
    @Generated
    private List<String> fileIds;

    /*
     * The data sources to be used. This option is mutually exclusive with the `fileIds` property.
     */
    @Generated
    private List<VectorStoreDataSource> dataSources;

    /**
     * Creates an instance of CodeInterpreterToolResource class.
     */
    @Generated
    public CodeInterpreterToolResource() {
    }

    /**
     * Get the fileIds property: A list of file IDs made available to the `code_interpreter` tool. There can be a
     * maximum of 20 files
     * associated with the tool.
     *
     * @return the fileIds value.
     */
    @Generated
    public List<String> getFileIds() {
        return this.fileIds;
    }

    /**
     * Set the fileIds property: A list of file IDs made available to the `code_interpreter` tool. There can be a
     * maximum of 20 files
     * associated with the tool.
     *
     * @param fileIds the fileIds value to set.
     * @return the CodeInterpreterToolResource object itself.
     */
    @Generated
    public CodeInterpreterToolResource setFileIds(List<String> fileIds) {
        this.fileIds = fileIds;
        return this;
    }

    /**
     * Get the dataSources property: The data sources to be used. This option is mutually exclusive with the `fileIds`
     * property.
     *
     * @return the dataSources value.
     */
    @Generated
    public List<VectorStoreDataSource> getDataSources() {
        return this.dataSources;
    }

    /**
     * Set the dataSources property: The data sources to be used. This option is mutually exclusive with the `fileIds`
     * property.
     *
     * @param dataSources the dataSources value to set.
     * @return the CodeInterpreterToolResource object itself.
     */
    @Generated
    public CodeInterpreterToolResource setDataSources(List<VectorStoreDataSource> dataSources) {
        this.dataSources = dataSources;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("file_ids", this.fileIds, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("data_sources", this.dataSources, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CodeInterpreterToolResource from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of CodeInterpreterToolResource if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the CodeInterpreterToolResource.
     */
    @Generated
    public static CodeInterpreterToolResource fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CodeInterpreterToolResource deserializedCodeInterpreterToolResource = new CodeInterpreterToolResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("file_ids".equals(fieldName)) {
                    List<String> fileIds = reader.readArray(reader1 -> reader1.getString());
                    deserializedCodeInterpreterToolResource.fileIds = fileIds;
                } else if ("data_sources".equals(fieldName)) {
                    List<VectorStoreDataSource> dataSources
                        = reader.readArray(reader1 -> VectorStoreDataSource.fromJson(reader1));
                    deserializedCodeInterpreterToolResource.dataSources = dataSources;
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedCodeInterpreterToolResource;
        });
    }
}
