// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Information for connecting one agent to another as a tool.
 */
@Immutable
public final class ConnectedAgentDetails implements JsonSerializable<ConnectedAgentDetails> {

    /*
     * The identifier of the child agent.
     */
    @Generated
    private final String id;

    /*
     * The name of the agent to be called.
     */
    @Generated
    private final String name;

    /*
     * A description of what the agent does, used by the model to choose when and how to call the agent.
     */
    @Generated
    private final String description;

    /**
     * Creates an instance of ConnectedAgentDetails class.
     *
     * @param id the id value to set.
     * @param name the name value to set.
     * @param description the description value to set.
     */
    @Generated
    public ConnectedAgentDetails(String id, String name, String description) {
        this.id = id;
        this.name = name;
        this.description = description;
    }

    /**
     * Get the id property: The identifier of the child agent.
     *
     * @return the id value.
     */
    @Generated
    public String getId() {
        return this.id;
    }

    /**
     * Get the name property: The name of the agent to be called.
     *
     * @return the name value.
     */
    @Generated
    public String getName() {
        return this.name;
    }

    /**
     * Get the description property: A description of what the agent does, used by the model to choose when and how to
     * call the agent.
     *
     * @return the description value.
     */
    @Generated
    public String getDescription() {
        return this.description;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ConnectedAgentDetails from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of ConnectedAgentDetails if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ConnectedAgentDetails.
     */
    @Generated
    public static ConnectedAgentDetails fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String id = null;
            String name = null;
            String description = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    name = reader.getString();
                } else if ("description".equals(fieldName)) {
                    description = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            return new ConnectedAgentDetails(id, name, description);
        });
    }
}
