// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The input definition information for a connected agent tool which defines a domain specific sub-agent.
 */
@Immutable
public final class ConnectedAgentToolDefinition extends ToolDefinition {

    /*
     * The object type.
     */
    @Generated
    private String type = "connected_agent";

    /*
     * The sub-agent to connect
     */
    @Generated
    private final ConnectedAgentDetails connectedAgent;

    /**
     * Creates an instance of ConnectedAgentToolDefinition class.
     *
     * @param connectedAgent the connectedAgent value to set.
     */
    @Generated
    public ConnectedAgentToolDefinition(ConnectedAgentDetails connectedAgent) {
        this.connectedAgent = connectedAgent;
    }

    /**
     * Get the type property: The object type.
     *
     * @return the type value.
     */
    @Generated
    @Override
    public String getType() {
        return this.type;
    }

    /**
     * Get the connectedAgent property: The sub-agent to connect.
     *
     * @return the connectedAgent value.
     */
    @Generated
    public ConnectedAgentDetails getConnectedAgent() {
        return this.connectedAgent;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("connected_agent", this.connectedAgent);
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ConnectedAgentToolDefinition from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of ConnectedAgentToolDefinition if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ConnectedAgentToolDefinition.
     */
    @Generated
    public static ConnectedAgentToolDefinition fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ConnectedAgentDetails connectedAgent = null;
            String type = "connected_agent";
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("connected_agent".equals(fieldName)) {
                    connectedAgent = ConnectedAgentDetails.fromJson(reader);
                } else if ("type".equals(fieldName)) {
                    type = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            ConnectedAgentToolDefinition deserializedConnectedAgentToolDefinition
                = new ConnectedAgentToolDefinition(connectedAgent);
            deserializedConnectedAgentToolDefinition.type = type;
            return deserializedConnectedAgentToolDefinition;
        });
    }
}
