// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The fabric data agent tool parameters.
 */
@Fluent
public final class FabricDataAgentToolParameters implements JsonSerializable<FabricDataAgentToolParameters> {

    /*
     * The connections attached to this tool. There can be a maximum of 1 connection
     * resource attached to the tool.
     */
    @Generated
    private List<ToolConnection> connectionList;

    /**
     * Creates an instance of FabricDataAgentToolParameters class.
     */
    @Generated
    public FabricDataAgentToolParameters() {
    }

    /**
     * Get the connectionList property: The connections attached to this tool. There can be a maximum of 1 connection
     * resource attached to the tool.
     *
     * @return the connectionList value.
     */
    @Generated
    public List<ToolConnection> getConnectionList() {
        return this.connectionList;
    }

    /**
     * Set the connectionList property: The connections attached to this tool. There can be a maximum of 1 connection
     * resource attached to the tool.
     *
     * @param connectionList the connectionList value to set.
     * @return the FabricDataAgentToolParameters object itself.
     */
    @Generated
    public FabricDataAgentToolParameters setConnectionList(List<ToolConnection> connectionList) {
        this.connectionList = connectionList;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("connections", this.connectionList, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of FabricDataAgentToolParameters from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of FabricDataAgentToolParameters if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the FabricDataAgentToolParameters.
     */
    @Generated
    public static FabricDataAgentToolParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            FabricDataAgentToolParameters deserializedFabricDataAgentToolParameters
                = new FabricDataAgentToolParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("connections".equals(fieldName)) {
                    List<ToolConnection> connectionList = reader.readArray(reader1 -> ToolConnection.fromJson(reader1));
                    deserializedFabricDataAgentToolParameters.connectionList = connectionList;
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedFabricDataAgentToolParameters;
        });
    }
}
