// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The response data from a file list operation.
 */
@Immutable
public final class FileListResponse implements JsonSerializable<FileListResponse> {

    /*
     * The object type, which is always 'list'.
     */
    @Generated
    private final String object = "list";

    /*
     * The files returned for the request.
     */
    @Generated
    private final List<FileInfo> data;

    /**
     * Creates an instance of FileListResponse class.
     *
     * @param data the data value to set.
     */
    @Generated
    private FileListResponse(List<FileInfo> data) {
        this.data = data;
    }

    /**
     * Get the object property: The object type, which is always 'list'.
     *
     * @return the object value.
     */
    @Generated
    public String getObject() {
        return this.object;
    }

    /**
     * Get the data property: The files returned for the request.
     *
     * @return the data value.
     */
    @Generated
    public List<FileInfo> getData() {
        return this.data;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("object", this.object);
        jsonWriter.writeArrayField("data", this.data, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of FileListResponse from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of FileListResponse if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the FileListResponse.
     */
    @Generated
    public static FileListResponse fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            List<FileInfo> data = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("data".equals(fieldName)) {
                    data = reader.readArray(reader1 -> FileInfo.fromJson(reader1));
                } else {
                    reader.skipChildren();
                }
            }
            return new FileListResponse(data);
        });
    }
}
