// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Ranking options for file search.
 */
@Immutable
public final class FileSearchRankingOptions implements JsonSerializable<FileSearchRankingOptions> {

    /*
     * File search ranker.
     */
    @Generated
    private final String ranker;

    /*
     * Ranker search threshold.
     */
    @Generated
    private final double scoreThreshold;

    /**
     * Creates an instance of FileSearchRankingOptions class.
     *
     * @param ranker the ranker value to set.
     * @param scoreThreshold the scoreThreshold value to set.
     */
    @Generated
    public FileSearchRankingOptions(String ranker, double scoreThreshold) {
        this.ranker = ranker;
        this.scoreThreshold = scoreThreshold;
    }

    /**
     * Get the ranker property: File search ranker.
     *
     * @return the ranker value.
     */
    @Generated
    public String getRanker() {
        return this.ranker;
    }

    /**
     * Get the scoreThreshold property: Ranker search threshold.
     *
     * @return the scoreThreshold value.
     */
    @Generated
    public double getScoreThreshold() {
        return this.scoreThreshold;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("ranker", this.ranker);
        jsonWriter.writeDoubleField("score_threshold", this.scoreThreshold);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of FileSearchRankingOptions from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of FileSearchRankingOptions if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the FileSearchRankingOptions.
     */
    @Generated
    public static FileSearchRankingOptions fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String ranker = null;
            double scoreThreshold = 0.0;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("ranker".equals(fieldName)) {
                    ranker = reader.getString();
                } else if ("score_threshold".equals(fieldName)) {
                    scoreThreshold = reader.getDouble();
                } else {
                    reader.skipChildren();
                }
            }
            return new FileSearchRankingOptions(ranker, scoreThreshold);
        });
    }
}
