// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The input definition information for a file search tool as used to configure an agent.
 */
@Fluent
public final class FileSearchToolDefinition extends ToolDefinition {

    /*
     * The object type.
     */
    @Generated
    private String type = "file_search";

    /*
     * Options overrides for the file search tool.
     */
    @Generated
    private FileSearchToolDefinitionDetails fileSearch;

    /**
     * Creates an instance of FileSearchToolDefinition class.
     */
    @Generated
    public FileSearchToolDefinition() {
    }

    /**
     * Get the type property: The object type.
     *
     * @return the type value.
     */
    @Generated
    @Override
    public String getType() {
        return this.type;
    }

    /**
     * Get the fileSearch property: Options overrides for the file search tool.
     *
     * @return the fileSearch value.
     */
    @Generated
    public FileSearchToolDefinitionDetails getFileSearch() {
        return this.fileSearch;
    }

    /**
     * Set the fileSearch property: Options overrides for the file search tool.
     *
     * @param fileSearch the fileSearch value to set.
     * @return the FileSearchToolDefinition object itself.
     */
    @Generated
    public FileSearchToolDefinition setFileSearch(FileSearchToolDefinitionDetails fileSearch) {
        this.fileSearch = fileSearch;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeJsonField("file_search", this.fileSearch);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of FileSearchToolDefinition from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of FileSearchToolDefinition if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the FileSearchToolDefinition.
     */
    @Generated
    public static FileSearchToolDefinition fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            FileSearchToolDefinition deserializedFileSearchToolDefinition = new FileSearchToolDefinition();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedFileSearchToolDefinition.type = reader.getString();
                } else if ("file_search".equals(fieldName)) {
                    deserializedFileSearchToolDefinition.fileSearch = FileSearchToolDefinitionDetails.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedFileSearchToolDefinition;
        });
    }
}
