// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Options overrides for the file search tool.
 */
@Fluent
public final class FileSearchToolDefinitionDetails implements JsonSerializable<FileSearchToolDefinitionDetails> {

    /*
     * The maximum number of results the file search tool should output. The default is 20 for gpt-4* models and 5 for
     * gpt-3.5-turbo. This number should be between 1 and 50 inclusive.
     * 
     * Note that the file search tool may output fewer than `max_num_results` results. See the file search tool
     * documentation for more information.
     */
    @Generated
    private Integer maxNumResults;

    /*
     * Ranking options for file search.
     */
    @Generated
    private FileSearchRankingOptions rankingOptions;

    /**
     * Creates an instance of FileSearchToolDefinitionDetails class.
     */
    @Generated
    public FileSearchToolDefinitionDetails() {
    }

    /**
     * Get the maxNumResults property: The maximum number of results the file search tool should output. The default is
     * 20 for gpt-4* models and 5 for gpt-3.5-turbo. This number should be between 1 and 50 inclusive.
     *
     * Note that the file search tool may output fewer than `max_num_results` results. See the file search tool
     * documentation for more information.
     *
     * @return the maxNumResults value.
     */
    @Generated
    public Integer getMaxNumResults() {
        return this.maxNumResults;
    }

    /**
     * Set the maxNumResults property: The maximum number of results the file search tool should output. The default is
     * 20 for gpt-4* models and 5 for gpt-3.5-turbo. This number should be between 1 and 50 inclusive.
     *
     * Note that the file search tool may output fewer than `max_num_results` results. See the file search tool
     * documentation for more information.
     *
     * @param maxNumResults the maxNumResults value to set.
     * @return the FileSearchToolDefinitionDetails object itself.
     */
    @Generated
    public FileSearchToolDefinitionDetails setMaxNumResults(Integer maxNumResults) {
        this.maxNumResults = maxNumResults;
        return this;
    }

    /**
     * Get the rankingOptions property: Ranking options for file search.
     *
     * @return the rankingOptions value.
     */
    @Generated
    public FileSearchRankingOptions getRankingOptions() {
        return this.rankingOptions;
    }

    /**
     * Set the rankingOptions property: Ranking options for file search.
     *
     * @param rankingOptions the rankingOptions value to set.
     * @return the FileSearchToolDefinitionDetails object itself.
     */
    @Generated
    public FileSearchToolDefinitionDetails setRankingOptions(FileSearchRankingOptions rankingOptions) {
        this.rankingOptions = rankingOptions;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("max_num_results", this.maxNumResults);
        jsonWriter.writeJsonField("ranking_options", this.rankingOptions);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of FileSearchToolDefinitionDetails from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of FileSearchToolDefinitionDetails if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the FileSearchToolDefinitionDetails.
     */
    @Generated
    public static FileSearchToolDefinitionDetails fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            FileSearchToolDefinitionDetails deserializedFileSearchToolDefinitionDetails
                = new FileSearchToolDefinitionDetails();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("max_num_results".equals(fieldName)) {
                    deserializedFileSearchToolDefinitionDetails.maxNumResults = reader.getNullable(JsonReader::getInt);
                } else if ("ranking_options".equals(fieldName)) {
                    deserializedFileSearchToolDefinitionDetails.rankingOptions
                        = FileSearchRankingOptions.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedFileSearchToolDefinitionDetails;
        });
    }
}
