// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * A set of resources that are used by the `file_search` tool.
 */
@Fluent
public final class FileSearchToolResource implements JsonSerializable<FileSearchToolResource> {

    /*
     * The ID of the vector store attached to this agent. There can be a maximum of 1 vector
     * store attached to the agent.
     */
    @Generated
    private List<String> vectorStoreIds;

    /*
     * The list of vector store configuration objects from Azure.
     * This list is limited to one element.
     * The only element of this list contains the list of azure asset IDs used by the search tool.
     */
    @Generated
    private List<VectorStoreConfigurations> vectorStores;

    /**
     * Creates an instance of FileSearchToolResource class.
     */
    @Generated
    public FileSearchToolResource() {
    }

    /**
     * Get the vectorStoreIds property: The ID of the vector store attached to this agent. There can be a maximum of 1
     * vector
     * store attached to the agent.
     *
     * @return the vectorStoreIds value.
     */
    @Generated
    public List<String> getVectorStoreIds() {
        return this.vectorStoreIds;
    }

    /**
     * Set the vectorStoreIds property: The ID of the vector store attached to this agent. There can be a maximum of 1
     * vector
     * store attached to the agent.
     *
     * @param vectorStoreIds the vectorStoreIds value to set.
     * @return the FileSearchToolResource object itself.
     */
    @Generated
    public FileSearchToolResource setVectorStoreIds(List<String> vectorStoreIds) {
        this.vectorStoreIds = vectorStoreIds;
        return this;
    }

    /**
     * Get the vectorStores property: The list of vector store configuration objects from Azure.
     * This list is limited to one element.
     * The only element of this list contains the list of azure asset IDs used by the search tool.
     *
     * @return the vectorStores value.
     */
    @Generated
    public List<VectorStoreConfigurations> getVectorStores() {
        return this.vectorStores;
    }

    /**
     * Set the vectorStores property: The list of vector store configuration objects from Azure.
     * This list is limited to one element.
     * The only element of this list contains the list of azure asset IDs used by the search tool.
     *
     * @param vectorStores the vectorStores value to set.
     * @return the FileSearchToolResource object itself.
     */
    @Generated
    public FileSearchToolResource setVectorStores(List<VectorStoreConfigurations> vectorStores) {
        this.vectorStores = vectorStores;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("vector_store_ids", this.vectorStoreIds,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("vector_stores", this.vectorStores, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of FileSearchToolResource from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of FileSearchToolResource if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the FileSearchToolResource.
     */
    @Generated
    public static FileSearchToolResource fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            FileSearchToolResource deserializedFileSearchToolResource = new FileSearchToolResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("vector_store_ids".equals(fieldName)) {
                    List<String> vectorStoreIds = reader.readArray(reader1 -> reader1.getString());
                    deserializedFileSearchToolResource.vectorStoreIds = vectorStoreIds;
                } else if ("vector_stores".equals(fieldName)) {
                    List<VectorStoreConfigurations> vectorStores
                        = reader.readArray(reader1 -> VectorStoreConfigurations.fromJson(reader1));
                    deserializedFileSearchToolResource.vectorStores = vectorStores;
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedFileSearchToolResource;
        });
    }
}
