// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.core.util.BinaryData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The input definition information for a function.
 */
@Fluent
public final class FunctionDefinition implements JsonSerializable<FunctionDefinition> {

    /*
     * The name of the function to be called.
     */
    @Generated
    private final String name;

    /*
     * A description of what the function does, used by the model to choose when and how to call the function.
     */
    @Generated
    private String description;

    /*
     * The parameters the functions accepts, described as a JSON Schema object.
     */
    @Generated
    private final BinaryData parameters;

    /**
     * Creates an instance of FunctionDefinition class.
     *
     * @param name the name value to set.
     * @param parameters the parameters value to set.
     */
    @Generated
    public FunctionDefinition(String name, BinaryData parameters) {
        this.name = name;
        this.parameters = parameters;
    }

    /**
     * Get the name property: The name of the function to be called.
     *
     * @return the name value.
     */
    @Generated
    public String getName() {
        return this.name;
    }

    /**
     * Get the description property: A description of what the function does, used by the model to choose when and how
     * to call the function.
     *
     * @return the description value.
     */
    @Generated
    public String getDescription() {
        return this.description;
    }

    /**
     * Set the description property: A description of what the function does, used by the model to choose when and how
     * to call the function.
     *
     * @param description the description value to set.
     * @return the FunctionDefinition object itself.
     */
    @Generated
    public FunctionDefinition setDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the parameters property: The parameters the functions accepts, described as a JSON Schema object.
     *
     * @return the parameters value.
     */
    @Generated
    public BinaryData getParameters() {
        return this.parameters;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeFieldName("parameters");
        this.parameters.writeTo(jsonWriter);
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of FunctionDefinition from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of FunctionDefinition if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the FunctionDefinition.
     */
    @Generated
    public static FunctionDefinition fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String name = null;
            BinaryData parameters = null;
            String description = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                } else if ("parameters".equals(fieldName)) {
                    parameters
                        = reader.getNullable(nonNullReader -> BinaryData.fromObject(nonNullReader.readUntyped()));
                } else if ("description".equals(fieldName)) {
                    description = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            FunctionDefinition deserializedFunctionDefinition = new FunctionDefinition(name, parameters);
            deserializedFunctionDefinition.description = description;
            return deserializedFunctionDefinition;
        });
    }
}
