// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The input definition information for a function tool as used to configure an agent.
 */
@Immutable
public final class FunctionToolDefinition extends ToolDefinition {

    /*
     * The object type.
     */
    @Generated
    private String type = "function";

    /*
     * The definition of the concrete function that the function tool should call.
     */
    @Generated
    private final FunctionDefinition function;

    /**
     * Creates an instance of FunctionToolDefinition class.
     *
     * @param function the function value to set.
     */
    @Generated
    public FunctionToolDefinition(FunctionDefinition function) {
        this.function = function;
    }

    /**
     * Get the type property: The object type.
     *
     * @return the type value.
     */
    @Generated
    @Override
    public String getType() {
        return this.type;
    }

    /**
     * Get the function property: The definition of the concrete function that the function tool should call.
     *
     * @return the function value.
     */
    @Generated
    public FunctionDefinition getFunction() {
        return this.function;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("function", this.function);
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of FunctionToolDefinition from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of FunctionToolDefinition if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the FunctionToolDefinition.
     */
    @Generated
    public static FunctionToolDefinition fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            FunctionDefinition function = null;
            String type = "function";
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("function".equals(fieldName)) {
                    function = FunctionDefinition.fromJson(reader);
                } else if ("type".equals(fieldName)) {
                    type = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            FunctionToolDefinition deserializedFunctionToolDefinition = new FunctionToolDefinition(function);
            deserializedFunctionToolDefinition.type = type;
            return deserializedFunctionToolDefinition;
        });
    }
}
