// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The reason why the run is incomplete. This will point to which specific token limit was reached over the course of
 * the run.
 */
public final class IncompleteDetailsReason extends ExpandableStringEnum<IncompleteDetailsReason> {

    /**
     * Maximum completion tokens exceeded.
     */
    @Generated
    public static final IncompleteDetailsReason MAX_COMPLETION_TOKENS = fromString("max_completion_tokens");

    /**
     * Maximum prompt tokens exceeded.
     */
    @Generated
    public static final IncompleteDetailsReason MAX_PROMPT_TOKENS = fromString("max_prompt_tokens");

    /**
     * Creates a new instance of IncompleteDetailsReason value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Generated
    @Deprecated
    public IncompleteDetailsReason() {
    }

    /**
     * Creates or finds a IncompleteDetailsReason from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding IncompleteDetailsReason.
     */
    @Generated
    public static IncompleteDetailsReason fromString(String name) {
        return fromString(name, IncompleteDetailsReason.class);
    }

    /**
     * Gets known IncompleteDetailsReason values.
     *
     * @return known IncompleteDetailsReason values.
     */
    @Generated
    public static Collection<IncompleteDetailsReason> values() {
        return values(IncompleteDetailsReason.class);
    }
}
