// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Details on why the run is incomplete. Will be `null` if the run is not incomplete.
 */
@Immutable
public final class IncompleteRunDetails implements JsonSerializable<IncompleteRunDetails> {

    /*
     * The reason why the run is incomplete. This indicates which specific token limit was reached during the run.
     */
    @Generated
    private final IncompleteDetailsReason reason;

    /**
     * Creates an instance of IncompleteRunDetails class.
     *
     * @param reason the reason value to set.
     */
    @Generated
    private IncompleteRunDetails(IncompleteDetailsReason reason) {
        this.reason = reason;
    }

    /**
     * Get the reason property: The reason why the run is incomplete. This indicates which specific token limit was
     * reached during the run.
     *
     * @return the reason value.
     */
    @Generated
    public IncompleteDetailsReason getReason() {
        return this.reason;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("reason", this.reason == null ? null : this.reason.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of IncompleteRunDetails from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of IncompleteRunDetails if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the IncompleteRunDetails.
     */
    @Generated
    public static IncompleteRunDetails fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            IncompleteDetailsReason reason = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("reason".equals(fieldName)) {
                    reason = IncompleteDetailsReason.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }
            return new IncompleteRunDetails(reason);
        });
    }
}
