// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * An object describing the expected output of the model. If `json_object` only `function` type `tools` are allowed to
 * be passed to the Run.
 * If `text` the model can return text or any value needed.
 */
@Fluent
public final class InternalPersistentAgentsResponseFormat
    implements JsonSerializable<InternalPersistentAgentsResponseFormat> {

    /*
     * Must be one of `text` or `json_object`.
     */
    @Generated
    private ResponseFormat type;

    /**
     * Creates an instance of InternalPersistentAgentsResponseFormat class.
     */
    @Generated
    public InternalPersistentAgentsResponseFormat() {
    }

    /**
     * Get the type property: Must be one of `text` or `json_object`.
     *
     * @return the type value.
     */
    @Generated
    public ResponseFormat getType() {
        return this.type;
    }

    /**
     * Set the type property: Must be one of `text` or `json_object`.
     *
     * @param type the type value to set.
     * @return the InternalPersistentAgentsResponseFormat object itself.
     */
    @Generated
    public InternalPersistentAgentsResponseFormat setType(ResponseFormat type) {
        this.type = type;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of InternalPersistentAgentsResponseFormat from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of InternalPersistentAgentsResponseFormat if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the InternalPersistentAgentsResponseFormat.
     */
    @Generated
    public static InternalPersistentAgentsResponseFormat fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            InternalPersistentAgentsResponseFormat deserializedInternalPersistentAgentsResponseFormat
                = new InternalPersistentAgentsResponseFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedInternalPersistentAgentsResponseFormat.type
                        = ResponseFormat.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedInternalPersistentAgentsResponseFormat;
        });
    }
}
