// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.core.util.BinaryData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * This describes to which tools a file has been attached.
 */
@Fluent
public final class MessageAttachment implements JsonSerializable<MessageAttachment> {

    /*
     * The ID of the file to attach to the message.
     */
    @Generated
    private String fileId;

    /*
     * Azure asset ID.
     */
    @Generated
    private VectorStoreDataSource dataSource;

    /*
     * The tools to add to this file.
     */
    @Generated
    private final List<BinaryData> tools;

    /**
     * Creates an instance of MessageAttachment class.
     *
     * @param tools the tools value to set.
     */
    @Generated
    public MessageAttachment(List<BinaryData> tools) {
        this.tools = tools;
    }

    /**
     * Get the fileId property: The ID of the file to attach to the message.
     *
     * @return the fileId value.
     */
    @Generated
    public String getFileId() {
        return this.fileId;
    }

    /**
     * Set the fileId property: The ID of the file to attach to the message.
     *
     * @param fileId the fileId value to set.
     * @return the MessageAttachment object itself.
     */
    @Generated
    public MessageAttachment setFileId(String fileId) {
        this.fileId = fileId;
        return this;
    }

    /**
     * Get the dataSource property: Azure asset ID.
     *
     * @return the dataSource value.
     */
    @Generated
    public VectorStoreDataSource getDataSource() {
        return this.dataSource;
    }

    /**
     * Set the dataSource property: Azure asset ID.
     *
     * @param dataSource the dataSource value to set.
     * @return the MessageAttachment object itself.
     */
    @Generated
    public MessageAttachment setDataSource(VectorStoreDataSource dataSource) {
        this.dataSource = dataSource;
        return this;
    }

    /**
     * Get the tools property: The tools to add to this file.
     *
     * @return the tools value.
     */
    @Generated
    public List<BinaryData> getTools() {
        return this.tools;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("tools", this.tools,
            (writer, element) -> writer.writeUntyped(element == null ? null : element.toObject(Object.class)));
        jsonWriter.writeStringField("file_id", this.fileId);
        jsonWriter.writeJsonField("data_source", this.dataSource);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MessageAttachment from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of MessageAttachment if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the MessageAttachment.
     */
    @Generated
    public static MessageAttachment fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            List<BinaryData> tools = null;
            String fileId = null;
            VectorStoreDataSource dataSource = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("tools".equals(fieldName)) {
                    tools = reader.readArray(reader1 -> reader1
                        .getNullable(nonNullReader -> BinaryData.fromObject(nonNullReader.readUntyped())));
                } else if ("file_id".equals(fieldName)) {
                    fileId = reader.getString();
                } else if ("data_source".equals(fieldName)) {
                    dataSource = VectorStoreDataSource.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }
            MessageAttachment deserializedMessageAttachment = new MessageAttachment(tools);
            deserializedMessageAttachment.fileId = fileId;
            deserializedMessageAttachment.dataSource = dataSource;
            return deserializedMessageAttachment;
        });
    }
}
