// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Specifies the kind of content block within a message. Could be text, an image file, an external image URL, or an
 * unknown future type.
 */
public final class MessageBlockType extends ExpandableStringEnum<MessageBlockType> {

    /**
     * Indicates a block containing text content.
     */
    @Generated
    public static final MessageBlockType TEXT = fromString("text");

    /**
     * Indicates a block referencing an internally uploaded image file.
     */
    @Generated
    public static final MessageBlockType IMAGE_FILE = fromString("image_file");

    /**
     * Indicates a block referencing an external image URL.
     */
    @Generated
    public static final MessageBlockType IMAGE_URL = fromString("image_url");

    /**
     * Creates a new instance of MessageBlockType value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Generated
    @Deprecated
    public MessageBlockType() {
    }

    /**
     * Creates or finds a MessageBlockType from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding MessageBlockType.
     */
    @Generated
    public static MessageBlockType fromString(String name) {
        return fromString(name, MessageBlockType.class);
    }

    /**
     * Gets known MessageBlockType values.
     *
     * @return known MessageBlockType values.
     */
    @Generated
    public static Collection<MessageBlockType> values() {
        return values(MessageBlockType.class);
    }
}
