// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Represents a message delta i.e. any changed fields on a message during streaming.
 */
@Immutable
public final class MessageDeltaChunk implements JsonSerializable<MessageDeltaChunk> {

    /*
     * The identifier of the message, which can be referenced in API endpoints.
     */
    @Generated
    private final String id;

    /*
     * The object type, which is always `thread.message.delta`.
     */
    @Generated
    private final String object = "thread.message.delta";

    /*
     * The delta containing the fields that have changed on the Message.
     */
    @Generated
    private final MessageDelta delta;

    /**
     * Creates an instance of MessageDeltaChunk class.
     *
     * @param id the id value to set.
     * @param delta the delta value to set.
     */
    @Generated
    private MessageDeltaChunk(String id, MessageDelta delta) {
        this.id = id;
        this.delta = delta;
    }

    /**
     * Get the id property: The identifier of the message, which can be referenced in API endpoints.
     *
     * @return the id value.
     */
    @Generated
    public String getId() {
        return this.id;
    }

    /**
     * Get the object property: The object type, which is always `thread.message.delta`.
     *
     * @return the object value.
     */
    @Generated
    public String getObject() {
        return this.object;
    }

    /**
     * Get the delta property: The delta containing the fields that have changed on the Message.
     *
     * @return the delta value.
     */
    @Generated
    public MessageDelta getDelta() {
        return this.delta;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("object", this.object);
        jsonWriter.writeJsonField("delta", this.delta);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MessageDeltaChunk from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of MessageDeltaChunk if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the MessageDeltaChunk.
     */
    @Generated
    public static MessageDeltaChunk fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String id = null;
            MessageDelta delta = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                } else if ("delta".equals(fieldName)) {
                    delta = MessageDelta.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }
            return new MessageDeltaChunk(id, delta);
        });
    }
}
