// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Represents a streamed image file content part within a streaming message delta chunk.
 */
@Immutable
public final class MessageDeltaImageFileContent extends MessageDeltaContent {

    /*
     * The type of content for this content part.
     */
    @Generated
    private String type = "image_file";

    /*
     * The image_file data.
     */
    @Generated
    private MessageDeltaImageFileContentObject imageFile;

    /**
     * Creates an instance of MessageDeltaImageFileContent class.
     *
     * @param index the index value to set.
     */
    @Generated
    private MessageDeltaImageFileContent(int index) {
        super(index);
    }

    /**
     * Get the type property: The type of content for this content part.
     *
     * @return the type value.
     */
    @Generated
    @Override
    public String getType() {
        return this.type;
    }

    /**
     * Get the imageFile property: The image_file data.
     *
     * @return the imageFile value.
     */
    @Generated
    public MessageDeltaImageFileContentObject getImageFile() {
        return this.imageFile;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("index", getIndex());
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeJsonField("image_file", this.imageFile);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MessageDeltaImageFileContent from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of MessageDeltaImageFileContent if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the MessageDeltaImageFileContent.
     */
    @Generated
    public static MessageDeltaImageFileContent fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            int index = 0;
            String type = "image_file";
            MessageDeltaImageFileContentObject imageFile = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("index".equals(fieldName)) {
                    index = reader.getInt();
                } else if ("type".equals(fieldName)) {
                    type = reader.getString();
                } else if ("image_file".equals(fieldName)) {
                    imageFile = MessageDeltaImageFileContentObject.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }
            MessageDeltaImageFileContent deserializedMessageDeltaImageFileContent
                = new MessageDeltaImageFileContent(index);
            deserializedMessageDeltaImageFileContent.type = type;
            deserializedMessageDeltaImageFileContent.imageFile = imageFile;
            return deserializedMessageDeltaImageFileContent;
        });
    }
}
