// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Represents the 'image_file' payload within streaming image file content.
 */
@Immutable
public final class MessageDeltaImageFileContentObject implements JsonSerializable<MessageDeltaImageFileContentObject> {

    /*
     * The file ID of the image in the message content.
     */
    @Generated
    private String fileId;

    /**
     * Creates an instance of MessageDeltaImageFileContentObject class.
     */
    @Generated
    private MessageDeltaImageFileContentObject() {
    }

    /**
     * Get the fileId property: The file ID of the image in the message content.
     *
     * @return the fileId value.
     */
    @Generated
    public String getFileId() {
        return this.fileId;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("file_id", this.fileId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MessageDeltaImageFileContentObject from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of MessageDeltaImageFileContentObject if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MessageDeltaImageFileContentObject.
     */
    @Generated
    public static MessageDeltaImageFileContentObject fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MessageDeltaImageFileContentObject deserializedMessageDeltaImageFileContentObject
                = new MessageDeltaImageFileContentObject();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("file_id".equals(fieldName)) {
                    deserializedMessageDeltaImageFileContentObject.fileId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedMessageDeltaImageFileContentObject;
        });
    }
}
