// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Represents a streamed text content part within a streaming message delta chunk.
 */
@Immutable
public final class MessageDeltaTextContent extends MessageDeltaContent {

    /*
     * The type of content for this content part.
     */
    @Generated
    private String type = "text";

    /*
     * The text content details.
     */
    @Generated
    private MessageDeltaTextContentObject text;

    /**
     * Creates an instance of MessageDeltaTextContent class.
     *
     * @param index the index value to set.
     */
    @Generated
    private MessageDeltaTextContent(int index) {
        super(index);
    }

    /**
     * Get the type property: The type of content for this content part.
     *
     * @return the type value.
     */
    @Generated
    @Override
    public String getType() {
        return this.type;
    }

    /**
     * Get the text property: The text content details.
     *
     * @return the text value.
     */
    @Generated
    public MessageDeltaTextContentObject getText() {
        return this.text;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("index", getIndex());
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeJsonField("text", this.text);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MessageDeltaTextContent from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of MessageDeltaTextContent if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the MessageDeltaTextContent.
     */
    @Generated
    public static MessageDeltaTextContent fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            int index = 0;
            String type = "text";
            MessageDeltaTextContentObject text = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("index".equals(fieldName)) {
                    index = reader.getInt();
                } else if ("type".equals(fieldName)) {
                    type = reader.getString();
                } else if ("text".equals(fieldName)) {
                    text = MessageDeltaTextContentObject.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }
            MessageDeltaTextContent deserializedMessageDeltaTextContent = new MessageDeltaTextContent(index);
            deserializedMessageDeltaTextContent.type = type;
            deserializedMessageDeltaTextContent.text = text;
            return deserializedMessageDeltaTextContent;
        });
    }
}
