// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Represents a streamed file path annotation applied to a streaming text content part.
 */
@Immutable
public final class MessageDeltaTextFilePathAnnotation extends MessageDeltaTextAnnotation {

    /*
     * The type of the text content annotation.
     */
    @Generated
    private String type = "file_path";

    /*
     * The file path information.
     */
    @Generated
    private MessageDeltaTextFilePathAnnotationObject filePath;

    /*
     * The start index of this annotation in the content text.
     */
    @Generated
    private Integer startIndex;

    /*
     * The end index of this annotation in the content text.
     */
    @Generated
    private Integer endIndex;

    /*
     * The text in the message content that needs to be replaced
     */
    @Generated
    private String text;

    /**
     * Creates an instance of MessageDeltaTextFilePathAnnotation class.
     *
     * @param index the index value to set.
     */
    @Generated
    private MessageDeltaTextFilePathAnnotation(int index) {
        super(index);
    }

    /**
     * Get the type property: The type of the text content annotation.
     *
     * @return the type value.
     */
    @Generated
    @Override
    public String getType() {
        return this.type;
    }

    /**
     * Get the filePath property: The file path information.
     *
     * @return the filePath value.
     */
    @Generated
    public MessageDeltaTextFilePathAnnotationObject getFilePath() {
        return this.filePath;
    }

    /**
     * Get the startIndex property: The start index of this annotation in the content text.
     *
     * @return the startIndex value.
     */
    @Generated
    public Integer getStartIndex() {
        return this.startIndex;
    }

    /**
     * Get the endIndex property: The end index of this annotation in the content text.
     *
     * @return the endIndex value.
     */
    @Generated
    public Integer getEndIndex() {
        return this.endIndex;
    }

    /**
     * Get the text property: The text in the message content that needs to be replaced.
     *
     * @return the text value.
     */
    @Generated
    public String getText() {
        return this.text;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("index", getIndex());
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeJsonField("file_path", this.filePath);
        jsonWriter.writeNumberField("start_index", this.startIndex);
        jsonWriter.writeNumberField("end_index", this.endIndex);
        jsonWriter.writeStringField("text", this.text);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MessageDeltaTextFilePathAnnotation from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of MessageDeltaTextFilePathAnnotation if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the MessageDeltaTextFilePathAnnotation.
     */
    @Generated
    public static MessageDeltaTextFilePathAnnotation fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            int index = 0;
            String type = "file_path";
            MessageDeltaTextFilePathAnnotationObject filePath = null;
            Integer startIndex = null;
            Integer endIndex = null;
            String text = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("index".equals(fieldName)) {
                    index = reader.getInt();
                } else if ("type".equals(fieldName)) {
                    type = reader.getString();
                } else if ("file_path".equals(fieldName)) {
                    filePath = MessageDeltaTextFilePathAnnotationObject.fromJson(reader);
                } else if ("start_index".equals(fieldName)) {
                    startIndex = reader.getNullable(JsonReader::getInt);
                } else if ("end_index".equals(fieldName)) {
                    endIndex = reader.getNullable(JsonReader::getInt);
                } else if ("text".equals(fieldName)) {
                    text = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            MessageDeltaTextFilePathAnnotation deserializedMessageDeltaTextFilePathAnnotation
                = new MessageDeltaTextFilePathAnnotation(index);
            deserializedMessageDeltaTextFilePathAnnotation.type = type;
            deserializedMessageDeltaTextFilePathAnnotation.filePath = filePath;
            deserializedMessageDeltaTextFilePathAnnotation.startIndex = startIndex;
            deserializedMessageDeltaTextFilePathAnnotation.endIndex = endIndex;
            deserializedMessageDeltaTextFilePathAnnotation.text = text;
            return deserializedMessageDeltaTextFilePathAnnotation;
        });
    }
}
