// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Represents the data of a streamed file path annotation as applied to a streaming text content part.
 */
@Immutable
public final class MessageDeltaTextFilePathAnnotationObject
    implements JsonSerializable<MessageDeltaTextFilePathAnnotationObject> {

    /*
     * The file ID for the annotation.
     */
    @Generated
    private String fileId;

    /**
     * Creates an instance of MessageDeltaTextFilePathAnnotationObject class.
     */
    @Generated
    private MessageDeltaTextFilePathAnnotationObject() {
    }

    /**
     * Get the fileId property: The file ID for the annotation.
     *
     * @return the fileId value.
     */
    @Generated
    public String getFileId() {
        return this.fileId;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("file_id", this.fileId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MessageDeltaTextFilePathAnnotationObject from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of MessageDeltaTextFilePathAnnotationObject if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MessageDeltaTextFilePathAnnotationObject.
     */
    @Generated
    public static MessageDeltaTextFilePathAnnotationObject fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MessageDeltaTextFilePathAnnotationObject deserializedMessageDeltaTextFilePathAnnotationObject
                = new MessageDeltaTextFilePathAnnotationObject();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("file_id".equals(fieldName)) {
                    deserializedMessageDeltaTextFilePathAnnotationObject.fileId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedMessageDeltaTextFilePathAnnotationObject;
        });
    }
}
