// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * A citation within the message that points to a specific URL associated with the message. Generated when the agent
 * uses tools such as 'bing_grounding' to search the Internet.
 */
@Immutable
public final class MessageDeltaTextUrlCitationAnnotation extends MessageDeltaTextAnnotation {

    /*
     * The type of the text content annotation.
     */
    @Generated
    private String type = "url_citation";

    /*
     * The details of the URL citation.
     */
    @Generated
    private final MessageDeltaTextUrlCitationDetails urlCitation;

    /*
     * The first text index associated with this text annotation.
     */
    @Generated
    private Integer startIndex;

    /*
     * The last text index associated with this text annotation.
     */
    @Generated
    private Integer endIndex;

    /**
     * Creates an instance of MessageDeltaTextUrlCitationAnnotation class.
     *
     * @param index the index value to set.
     * @param urlCitation the urlCitation value to set.
     */
    @Generated
    private MessageDeltaTextUrlCitationAnnotation(int index, MessageDeltaTextUrlCitationDetails urlCitation) {
        super(index);
        this.urlCitation = urlCitation;
    }

    /**
     * Get the type property: The type of the text content annotation.
     *
     * @return the type value.
     */
    @Generated
    @Override
    public String getType() {
        return this.type;
    }

    /**
     * Get the urlCitation property: The details of the URL citation.
     *
     * @return the urlCitation value.
     */
    @Generated
    public MessageDeltaTextUrlCitationDetails getUrlCitation() {
        return this.urlCitation;
    }

    /**
     * Get the startIndex property: The first text index associated with this text annotation.
     *
     * @return the startIndex value.
     */
    @Generated
    public Integer getStartIndex() {
        return this.startIndex;
    }

    /**
     * Get the endIndex property: The last text index associated with this text annotation.
     *
     * @return the endIndex value.
     */
    @Generated
    public Integer getEndIndex() {
        return this.endIndex;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("index", getIndex());
        jsonWriter.writeJsonField("url_citation", this.urlCitation);
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeNumberField("start_index", this.startIndex);
        jsonWriter.writeNumberField("end_index", this.endIndex);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MessageDeltaTextUrlCitationAnnotation from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of MessageDeltaTextUrlCitationAnnotation if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the MessageDeltaTextUrlCitationAnnotation.
     */
    @Generated
    public static MessageDeltaTextUrlCitationAnnotation fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            int index = 0;
            MessageDeltaTextUrlCitationDetails urlCitation = null;
            String type = "url_citation";
            Integer startIndex = null;
            Integer endIndex = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("index".equals(fieldName)) {
                    index = reader.getInt();
                } else if ("url_citation".equals(fieldName)) {
                    urlCitation = MessageDeltaTextUrlCitationDetails.fromJson(reader);
                } else if ("type".equals(fieldName)) {
                    type = reader.getString();
                } else if ("start_index".equals(fieldName)) {
                    startIndex = reader.getNullable(JsonReader::getInt);
                } else if ("end_index".equals(fieldName)) {
                    endIndex = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }
            MessageDeltaTextUrlCitationAnnotation deserializedMessageDeltaTextUrlCitationAnnotation
                = new MessageDeltaTextUrlCitationAnnotation(index, urlCitation);
            deserializedMessageDeltaTextUrlCitationAnnotation.type = type;
            deserializedMessageDeltaTextUrlCitationAnnotation.startIndex = startIndex;
            deserializedMessageDeltaTextUrlCitationAnnotation.endIndex = endIndex;
            return deserializedMessageDeltaTextUrlCitationAnnotation;
        });
    }
}
