// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * A representation of a URL citation, as used in text thread message content.
 */
@Immutable
public final class MessageDeltaTextUrlCitationDetails implements JsonSerializable<MessageDeltaTextUrlCitationDetails> {

    /*
     * The URL associated with this citation.
     */
    @Generated
    private final String url;

    /*
     * The title of the URL.
     */
    @Generated
    private String title;

    /**
     * Creates an instance of MessageDeltaTextUrlCitationDetails class.
     *
     * @param url the url value to set.
     */
    @Generated
    private MessageDeltaTextUrlCitationDetails(String url) {
        this.url = url;
    }

    /**
     * Get the url property: The URL associated with this citation.
     *
     * @return the url value.
     */
    @Generated
    public String getUrl() {
        return this.url;
    }

    /**
     * Get the title property: The title of the URL.
     *
     * @return the title value.
     */
    @Generated
    public String getTitle() {
        return this.title;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("url", this.url);
        jsonWriter.writeStringField("title", this.title);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MessageDeltaTextUrlCitationDetails from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of MessageDeltaTextUrlCitationDetails if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the MessageDeltaTextUrlCitationDetails.
     */
    @Generated
    public static MessageDeltaTextUrlCitationDetails fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String url = null;
            String title = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("url".equals(fieldName)) {
                    url = reader.getString();
                } else if ("title".equals(fieldName)) {
                    title = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            MessageDeltaTextUrlCitationDetails deserializedMessageDeltaTextUrlCitationDetails
                = new MessageDeltaTextUrlCitationDetails(url);
            deserializedMessageDeltaTextUrlCitationDetails.title = title;
            return deserializedMessageDeltaTextUrlCitationDetails;
        });
    }
}
