// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Defines how an internally uploaded image file is referenced when creating an image-file block.
 */
@Fluent
public final class MessageImageFileParam implements JsonSerializable<MessageImageFileParam> {

    /*
     * The ID of the previously uploaded image file.
     */
    @Generated
    private final String fileId;

    /*
     * Optional detail level for the image (auto, low, or high).
     */
    @Generated
    private ImageDetailLevel detail;

    /**
     * Creates an instance of MessageImageFileParam class.
     *
     * @param fileId the fileId value to set.
     */
    @Generated
    public MessageImageFileParam(String fileId) {
        this.fileId = fileId;
    }

    /**
     * Get the fileId property: The ID of the previously uploaded image file.
     *
     * @return the fileId value.
     */
    @Generated
    public String getFileId() {
        return this.fileId;
    }

    /**
     * Get the detail property: Optional detail level for the image (auto, low, or high).
     *
     * @return the detail value.
     */
    @Generated
    public ImageDetailLevel getDetail() {
        return this.detail;
    }

    /**
     * Set the detail property: Optional detail level for the image (auto, low, or high).
     *
     * @param detail the detail value to set.
     * @return the MessageImageFileParam object itself.
     */
    @Generated
    public MessageImageFileParam setDetail(ImageDetailLevel detail) {
        this.detail = detail;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("file_id", this.fileId);
        jsonWriter.writeStringField("detail", this.detail == null ? null : this.detail.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MessageImageFileParam from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of MessageImageFileParam if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the MessageImageFileParam.
     */
    @Generated
    public static MessageImageFileParam fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String fileId = null;
            ImageDetailLevel detail = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("file_id".equals(fieldName)) {
                    fileId = reader.getString();
                } else if ("detail".equals(fieldName)) {
                    detail = ImageDetailLevel.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }
            MessageImageFileParam deserializedMessageImageFileParam = new MessageImageFileParam(fileId);
            deserializedMessageImageFileParam.detail = detail;
            return deserializedMessageImageFileParam;
        });
    }
}
