// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Information providing additional detail about a message entering an incomplete status.
 */
@Immutable
public final class MessageIncompleteDetails implements JsonSerializable<MessageIncompleteDetails> {

    /*
     * The provided reason describing why the message was marked as incomplete.
     */
    @Generated
    private final MessageIncompleteDetailsReason reason;

    /**
     * Creates an instance of MessageIncompleteDetails class.
     *
     * @param reason the reason value to set.
     */
    @Generated
    private MessageIncompleteDetails(MessageIncompleteDetailsReason reason) {
        this.reason = reason;
    }

    /**
     * Get the reason property: The provided reason describing why the message was marked as incomplete.
     *
     * @return the reason value.
     */
    @Generated
    public MessageIncompleteDetailsReason getReason() {
        return this.reason;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("reason", this.reason == null ? null : this.reason.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MessageIncompleteDetails from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of MessageIncompleteDetails if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the MessageIncompleteDetails.
     */
    @Generated
    public static MessageIncompleteDetails fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MessageIncompleteDetailsReason reason = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("reason".equals(fieldName)) {
                    reason = MessageIncompleteDetailsReason.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }
            return new MessageIncompleteDetails(reason);
        });
    }
}
