// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * A set of reasons describing why a message is marked as incomplete.
 */
public final class MessageIncompleteDetailsReason extends ExpandableStringEnum<MessageIncompleteDetailsReason> {

    /**
     * The run generating the message was terminated due to content filter flagging.
     */
    @Generated
    public static final MessageIncompleteDetailsReason CONTENT_FILTER = fromString("content_filter");

    /**
     * The run generating the message exhausted available tokens before completion.
     */
    @Generated
    public static final MessageIncompleteDetailsReason MAX_TOKENS = fromString("max_tokens");

    /**
     * The run generating the message was cancelled before completion.
     */
    @Generated
    public static final MessageIncompleteDetailsReason RUN_CANCELLED = fromString("run_cancelled");

    /**
     * The run generating the message failed.
     */
    @Generated
    public static final MessageIncompleteDetailsReason RUN_FAILED = fromString("run_failed");

    /**
     * The run generating the message expired.
     */
    @Generated
    public static final MessageIncompleteDetailsReason RUN_EXPIRED = fromString("run_expired");

    /**
     * Creates a new instance of MessageIncompleteDetailsReason value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Generated
    @Deprecated
    public MessageIncompleteDetailsReason() {
    }

    /**
     * Creates or finds a MessageIncompleteDetailsReason from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding MessageIncompleteDetailsReason.
     */
    @Generated
    public static MessageIncompleteDetailsReason fromString(String name) {
        return fromString(name, MessageIncompleteDetailsReason.class);
    }

    /**
     * Gets known MessageIncompleteDetailsReason values.
     *
     * @return known MessageIncompleteDetailsReason values.
     */
    @Generated
    public static Collection<MessageIncompleteDetailsReason> values() {
        return values(MessageIncompleteDetailsReason.class);
    }
}
