// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Defines a single content block when creating a message. The 'type' field determines whether it is text, an image
 * file, or an external image URL, etc.
 */
@Immutable
public class MessageInputContentBlock implements JsonSerializable<MessageInputContentBlock> {

    /*
     * Specifies which kind of content block this is (text, image_file, image_url, etc.).
     */
    @Generated
    private MessageBlockType type = MessageBlockType.fromString("MessageInputContentBlock");

    /**
     * Creates an instance of MessageInputContentBlock class.
     */
    @Generated
    public MessageInputContentBlock() {
    }

    /**
     * Get the type property: Specifies which kind of content block this is (text, image_file, image_url, etc.).
     *
     * @return the type value.
     */
    @Generated
    public MessageBlockType getType() {
        return this.type;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MessageInputContentBlock from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of MessageInputContentBlock if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MessageInputContentBlock.
     */
    @Generated
    public static MessageInputContentBlock fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject()) {
                // Prepare for reading
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    } else {
                        readerToUse.skipChildren();
                    }
                }
                // Use the discriminator value to determine which subtype should be deserialized.
                if ("text".equals(discriminatorValue)) {
                    return MessageInputTextBlock.fromJson(readerToUse.reset());
                } else if ("image_file".equals(discriminatorValue)) {
                    return MessageInputImageFileBlock.fromJson(readerToUse.reset());
                } else if ("image_url".equals(discriminatorValue)) {
                    return MessageInputImageUrlBlock.fromJson(readerToUse.reset());
                } else {
                    return fromJsonKnownDiscriminator(readerToUse.reset());
                }
            }
        });
    }

    @Generated
    static MessageInputContentBlock fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MessageInputContentBlock deserializedMessageInputContentBlock = new MessageInputContentBlock();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedMessageInputContentBlock.type = MessageBlockType.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedMessageInputContentBlock;
        });
    }
}
