// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * An image-file block in a new message, referencing an internally uploaded image by file ID.
 */
@Immutable
public final class MessageInputImageFileBlock extends MessageInputContentBlock {

    /*
     * Specifies which kind of content block this is (text, image_file, image_url, etc.).
     */
    @Generated
    private MessageBlockType type = MessageBlockType.IMAGE_FILE;

    /*
     * Information about the referenced image file, including file ID and optional detail level.
     */
    @Generated
    private final MessageImageFileParam imageFile;

    /**
     * Creates an instance of MessageInputImageFileBlock class.
     *
     * @param imageFile the imageFile value to set.
     */
    @Generated
    public MessageInputImageFileBlock(MessageImageFileParam imageFile) {
        this.imageFile = imageFile;
    }

    /**
     * Get the type property: Specifies which kind of content block this is (text, image_file, image_url, etc.).
     *
     * @return the type value.
     */
    @Generated
    @Override
    public MessageBlockType getType() {
        return this.type;
    }

    /**
     * Get the imageFile property: Information about the referenced image file, including file ID and optional detail
     * level.
     *
     * @return the imageFile value.
     */
    @Generated
    public MessageImageFileParam getImageFile() {
        return this.imageFile;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("image_file", this.imageFile);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MessageInputImageFileBlock from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of MessageInputImageFileBlock if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the MessageInputImageFileBlock.
     */
    @Generated
    public static MessageInputImageFileBlock fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MessageImageFileParam imageFile = null;
            MessageBlockType type = MessageBlockType.IMAGE_FILE;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("image_file".equals(fieldName)) {
                    imageFile = MessageImageFileParam.fromJson(reader);
                } else if ("type".equals(fieldName)) {
                    type = MessageBlockType.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }
            MessageInputImageFileBlock deserializedMessageInputImageFileBlock
                = new MessageInputImageFileBlock(imageFile);
            deserializedMessageInputImageFileBlock.type = type;
            return deserializedMessageInputImageFileBlock;
        });
    }
}
