// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * An image-URL block in a new message, referencing an external image by URL.
 */
@Immutable
public final class MessageInputImageUrlBlock extends MessageInputContentBlock {

    /*
     * Specifies which kind of content block this is (text, image_file, image_url, etc.).
     */
    @Generated
    private MessageBlockType type = MessageBlockType.IMAGE_URL;

    /*
     * Information about the external image URL, including the URL and optional detail level.
     */
    @Generated
    private final MessageImageUrlParam imageUrl;

    /**
     * Creates an instance of MessageInputImageUrlBlock class.
     *
     * @param imageUrl the imageUrl value to set.
     */
    @Generated
    public MessageInputImageUrlBlock(MessageImageUrlParam imageUrl) {
        this.imageUrl = imageUrl;
    }

    /**
     * Get the type property: Specifies which kind of content block this is (text, image_file, image_url, etc.).
     *
     * @return the type value.
     */
    @Generated
    @Override
    public MessageBlockType getType() {
        return this.type;
    }

    /**
     * Get the imageUrl property: Information about the external image URL, including the URL and optional detail level.
     *
     * @return the imageUrl value.
     */
    @Generated
    public MessageImageUrlParam getImageUrl() {
        return this.imageUrl;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("image_url", this.imageUrl);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MessageInputImageUrlBlock from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of MessageInputImageUrlBlock if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the MessageInputImageUrlBlock.
     */
    @Generated
    public static MessageInputImageUrlBlock fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MessageImageUrlParam imageUrl = null;
            MessageBlockType type = MessageBlockType.IMAGE_URL;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("image_url".equals(fieldName)) {
                    imageUrl = MessageImageUrlParam.fromJson(reader);
                } else if ("type".equals(fieldName)) {
                    type = MessageBlockType.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }
            MessageInputImageUrlBlock deserializedMessageInputImageUrlBlock = new MessageInputImageUrlBlock(imageUrl);
            deserializedMessageInputImageUrlBlock.type = type;
            return deserializedMessageInputImageUrlBlock;
        });
    }
}
