// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * A text block in a new message, containing plain text content.
 */
@Immutable
public final class MessageInputTextBlock extends MessageInputContentBlock {

    /*
     * Specifies which kind of content block this is (text, image_file, image_url, etc.).
     */
    @Generated
    private MessageBlockType type = MessageBlockType.TEXT;

    /*
     * The plain text content for this block.
     */
    @Generated
    private final String text;

    /**
     * Creates an instance of MessageInputTextBlock class.
     *
     * @param text the text value to set.
     */
    @Generated
    public MessageInputTextBlock(String text) {
        this.text = text;
    }

    /**
     * Get the type property: Specifies which kind of content block this is (text, image_file, image_url, etc.).
     *
     * @return the type value.
     */
    @Generated
    @Override
    public MessageBlockType getType() {
        return this.type;
    }

    /**
     * Get the text property: The plain text content for this block.
     *
     * @return the text value.
     */
    @Generated
    public String getText() {
        return this.text;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("text", this.text);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MessageInputTextBlock from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of MessageInputTextBlock if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the MessageInputTextBlock.
     */
    @Generated
    public static MessageInputTextBlock fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String text = null;
            MessageBlockType type = MessageBlockType.TEXT;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("text".equals(fieldName)) {
                    text = reader.getString();
                } else if ("type".equals(fieldName)) {
                    type = MessageBlockType.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }
            MessageInputTextBlock deserializedMessageInputTextBlock = new MessageInputTextBlock(text);
            deserializedMessageInputTextBlock.type = type;
            return deserializedMessageInputTextBlock;
        });
    }
}
