// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The possible values for roles attributed to messages in a thread.
 */
public final class MessageRole extends ExpandableStringEnum<MessageRole> {

    /**
     * The role representing the end-user.
     */
    @Generated
    public static final MessageRole USER = fromString("user");

    /**
     * The role representing the agent.
     */
    @Generated
    public static final MessageRole AGENT = fromString("assistant");

    /**
     * Creates a new instance of MessageRole value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Generated
    @Deprecated
    public MessageRole() {
    }

    /**
     * Creates or finds a MessageRole from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding MessageRole.
     */
    @Generated
    public static MessageRole fromString(String name) {
        return fromString(name, MessageRole.class);
    }

    /**
     * Gets known MessageRole values.
     *
     * @return known MessageRole values.
     */
    @Generated
    public static Collection<MessageRole> values() {
        return values(MessageRole.class);
    }
}
