// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The possible execution status values for a thread message.
 */
public final class MessageStatus extends ExpandableStringEnum<MessageStatus> {

    /**
     * A run is currently creating this message.
     */
    @Generated
    public static final MessageStatus IN_PROGRESS = fromString("in_progress");

    /**
     * This message is incomplete. See incomplete_details for more information.
     */
    @Generated
    public static final MessageStatus INCOMPLETE = fromString("incomplete");

    /**
     * This message was successfully completed by a run.
     */
    @Generated
    public static final MessageStatus COMPLETED = fromString("completed");

    /**
     * Creates a new instance of MessageStatus value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Generated
    @Deprecated
    public MessageStatus() {
    }

    /**
     * Creates or finds a MessageStatus from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding MessageStatus.
     */
    @Generated
    public static MessageStatus fromString(String name) {
        return fromString(name, MessageStatus.class);
    }

    /**
     * Gets known MessageStatus values.
     *
     * @return known MessageStatus values.
     */
    @Generated
    public static Collection<MessageStatus> values() {
        return values(MessageStatus.class);
    }
}
