// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Message operation related streaming events.
 */
public final class MessageStreamEvent extends ExpandableStringEnum<MessageStreamEvent> {

    /**
     * Event sent when a new message is created. The data of this event is of type ThreadMessage.
     */
    @Generated
    public static final MessageStreamEvent THREAD_MESSAGE_CREATED = fromString("thread.message.created");

    /**
     * Event sent when a message moves to `in_progress` status. The data of this event is of type ThreadMessage.
     */
    @Generated
    public static final MessageStreamEvent THREAD_MESSAGE_IN_PROGRESS = fromString("thread.message.in_progress");

    /**
     * Event sent when a message is being streamed. The data of this event is of type MessageDeltaChunk.
     */
    @Generated
    public static final MessageStreamEvent THREAD_MESSAGE_DELTA = fromString("thread.message.delta");

    /**
     * Event sent when a message is completed. The data of this event is of type ThreadMessage.
     */
    @Generated
    public static final MessageStreamEvent THREAD_MESSAGE_COMPLETED = fromString("thread.message.completed");

    /**
     * Event sent before a message is completed. The data of this event is of type ThreadMessage.
     */
    @Generated
    public static final MessageStreamEvent THREAD_MESSAGE_INCOMPLETE = fromString("thread.message.incomplete");

    /**
     * Creates a new instance of MessageStreamEvent value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Generated
    @Deprecated
    public MessageStreamEvent() {
    }

    /**
     * Creates or finds a MessageStreamEvent from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding MessageStreamEvent.
     */
    @Generated
    public static MessageStreamEvent fromString(String name) {
        return fromString(name, MessageStreamEvent.class);
    }

    /**
     * Gets known MessageStreamEvent values.
     *
     * @return known MessageStreamEvent values.
     */
    @Generated
    public static Collection<MessageStreamEvent> values() {
        return values(MessageStreamEvent.class);
    }
}
