// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * An abstract representation of an annotation to text thread message content.
 */
@Immutable
public class MessageTextAnnotation implements JsonSerializable<MessageTextAnnotation> {

    /*
     * The object type.
     */
    @Generated
    private String type = "MessageTextAnnotation";

    /*
     * The textual content associated with this text annotation item.
     */
    @Generated
    private final String text;

    /**
     * Creates an instance of MessageTextAnnotation class.
     *
     * @param text the text value to set.
     */
    @Generated
    protected MessageTextAnnotation(String text) {
        this.text = text;
    }

    /**
     * Get the type property: The object type.
     *
     * @return the type value.
     */
    @Generated
    public String getType() {
        return this.type;
    }

    /**
     * Get the text property: The textual content associated with this text annotation item.
     *
     * @return the text value.
     */
    @Generated
    public String getText() {
        return this.text;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("text", this.text);
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MessageTextAnnotation from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of MessageTextAnnotation if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the MessageTextAnnotation.
     */
    @Generated
    public static MessageTextAnnotation fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject()) {
                // Prepare for reading
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    } else {
                        readerToUse.skipChildren();
                    }
                }
                // Use the discriminator value to determine which subtype should be deserialized.
                if ("url_citation".equals(discriminatorValue)) {
                    return MessageTextUrlCitationAnnotation.fromJson(readerToUse.reset());
                } else if ("file_citation".equals(discriminatorValue)) {
                    return MessageTextFileCitationAnnotation.fromJson(readerToUse.reset());
                } else if ("file_path".equals(discriminatorValue)) {
                    return MessageTextFilePathAnnotation.fromJson(readerToUse.reset());
                } else {
                    return fromJsonKnownDiscriminator(readerToUse.reset());
                }
            }
        });
    }

    @Generated
    static MessageTextAnnotation fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String text = null;
            String type = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("text".equals(fieldName)) {
                    text = reader.getString();
                } else if ("type".equals(fieldName)) {
                    type = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            MessageTextAnnotation deserializedMessageTextAnnotation = new MessageTextAnnotation(text);
            deserializedMessageTextAnnotation.type = type;
            return deserializedMessageTextAnnotation;
        });
    }
}
