// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * A citation within the message that points to a specific quote from a specific File associated with the agent or the
 * message. Generated when the agent uses the 'file_search' tool to search files.
 */
@Immutable
public final class MessageTextFileCitationAnnotation extends MessageTextAnnotation {

    /*
     * The object type.
     */
    @Generated
    private String type = "file_citation";

    /*
     * A citation within the message that points to a specific quote from a specific file.
     * Generated when the agent uses the "file_search" tool to search files.
     */
    @Generated
    private final MessageTextFileCitationDetails fileCitation;

    /*
     * The first text index associated with this text annotation.
     */
    @Generated
    private Integer startIndex;

    /*
     * The last text index associated with this text annotation.
     */
    @Generated
    private Integer endIndex;

    /**
     * Creates an instance of MessageTextFileCitationAnnotation class.
     *
     * @param text the text value to set.
     * @param fileCitation the fileCitation value to set.
     */
    @Generated
    private MessageTextFileCitationAnnotation(String text, MessageTextFileCitationDetails fileCitation) {
        super(text);
        this.fileCitation = fileCitation;
    }

    /**
     * Get the type property: The object type.
     *
     * @return the type value.
     */
    @Generated
    @Override
    public String getType() {
        return this.type;
    }

    /**
     * Get the fileCitation property: A citation within the message that points to a specific quote from a specific
     * file.
     * Generated when the agent uses the "file_search" tool to search files.
     *
     * @return the fileCitation value.
     */
    @Generated
    public MessageTextFileCitationDetails getFileCitation() {
        return this.fileCitation;
    }

    /**
     * Get the startIndex property: The first text index associated with this text annotation.
     *
     * @return the startIndex value.
     */
    @Generated
    public Integer getStartIndex() {
        return this.startIndex;
    }

    /**
     * Get the endIndex property: The last text index associated with this text annotation.
     *
     * @return the endIndex value.
     */
    @Generated
    public Integer getEndIndex() {
        return this.endIndex;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("text", getText());
        jsonWriter.writeJsonField("file_citation", this.fileCitation);
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeNumberField("start_index", this.startIndex);
        jsonWriter.writeNumberField("end_index", this.endIndex);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MessageTextFileCitationAnnotation from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of MessageTextFileCitationAnnotation if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the MessageTextFileCitationAnnotation.
     */
    @Generated
    public static MessageTextFileCitationAnnotation fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String text = null;
            MessageTextFileCitationDetails fileCitation = null;
            String type = "file_citation";
            Integer startIndex = null;
            Integer endIndex = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("text".equals(fieldName)) {
                    text = reader.getString();
                } else if ("file_citation".equals(fieldName)) {
                    fileCitation = MessageTextFileCitationDetails.fromJson(reader);
                } else if ("type".equals(fieldName)) {
                    type = reader.getString();
                } else if ("start_index".equals(fieldName)) {
                    startIndex = reader.getNullable(JsonReader::getInt);
                } else if ("end_index".equals(fieldName)) {
                    endIndex = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }
            MessageTextFileCitationAnnotation deserializedMessageTextFileCitationAnnotation
                = new MessageTextFileCitationAnnotation(text, fileCitation);
            deserializedMessageTextFileCitationAnnotation.type = type;
            deserializedMessageTextFileCitationAnnotation.startIndex = startIndex;
            deserializedMessageTextFileCitationAnnotation.endIndex = endIndex;
            return deserializedMessageTextFileCitationAnnotation;
        });
    }
}
