// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * A citation within the message that points to a specific URL associated with the message. Generated when the agent
 * uses tools such as 'bing_grounding' to search the Internet.
 */
@Immutable
public final class MessageTextUrlCitationAnnotation extends MessageTextAnnotation {

    /*
     * The object type.
     */
    @Generated
    private String type = "url_citation";

    /*
     * The details of the URL citation.
     */
    @Generated
    private final MessageTextUrlCitationDetails urlCitation;

    /*
     * The first text index associated with this text annotation.
     */
    @Generated
    private Integer startIndex;

    /*
     * The last text index associated with this text annotation.
     */
    @Generated
    private Integer endIndex;

    /**
     * Creates an instance of MessageTextUrlCitationAnnotation class.
     *
     * @param text the text value to set.
     * @param urlCitation the urlCitation value to set.
     */
    @Generated
    private MessageTextUrlCitationAnnotation(String text, MessageTextUrlCitationDetails urlCitation) {
        super(text);
        this.urlCitation = urlCitation;
    }

    /**
     * Get the type property: The object type.
     *
     * @return the type value.
     */
    @Generated
    @Override
    public String getType() {
        return this.type;
    }

    /**
     * Get the urlCitation property: The details of the URL citation.
     *
     * @return the urlCitation value.
     */
    @Generated
    public MessageTextUrlCitationDetails getUrlCitation() {
        return this.urlCitation;
    }

    /**
     * Get the startIndex property: The first text index associated with this text annotation.
     *
     * @return the startIndex value.
     */
    @Generated
    public Integer getStartIndex() {
        return this.startIndex;
    }

    /**
     * Get the endIndex property: The last text index associated with this text annotation.
     *
     * @return the endIndex value.
     */
    @Generated
    public Integer getEndIndex() {
        return this.endIndex;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("text", getText());
        jsonWriter.writeJsonField("url_citation", this.urlCitation);
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeNumberField("start_index", this.startIndex);
        jsonWriter.writeNumberField("end_index", this.endIndex);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MessageTextUrlCitationAnnotation from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of MessageTextUrlCitationAnnotation if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the MessageTextUrlCitationAnnotation.
     */
    @Generated
    public static MessageTextUrlCitationAnnotation fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String text = null;
            MessageTextUrlCitationDetails urlCitation = null;
            String type = "url_citation";
            Integer startIndex = null;
            Integer endIndex = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("text".equals(fieldName)) {
                    text = reader.getString();
                } else if ("url_citation".equals(fieldName)) {
                    urlCitation = MessageTextUrlCitationDetails.fromJson(reader);
                } else if ("type".equals(fieldName)) {
                    type = reader.getString();
                } else if ("start_index".equals(fieldName)) {
                    startIndex = reader.getNullable(JsonReader::getInt);
                } else if ("end_index".equals(fieldName)) {
                    endIndex = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }
            MessageTextUrlCitationAnnotation deserializedMessageTextUrlCitationAnnotation
                = new MessageTextUrlCitationAnnotation(text, urlCitation);
            deserializedMessageTextUrlCitationAnnotation.type = type;
            deserializedMessageTextUrlCitationAnnotation.startIndex = startIndex;
            deserializedMessageTextUrlCitationAnnotation.endIndex = endIndex;
            return deserializedMessageTextUrlCitationAnnotation;
        });
    }
}
